/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.SingleColumnMapper;
import java.util.Date;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.serializers.SimpleDateSerializer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegerMapper
extends SingleColumnMapper.SingleFieldMapper<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(IntegerMapper.class);
    public static final Float DEFAULT_BOOST = Float.valueOf(1.0f);
    public final Float boost;

    public IntegerMapper(String field, String column, Boolean validated, Float boost) {
        super(field, column, (Boolean)true, validated, null, Integer.class, new AbstractType[]{AsciiType.instance, ByteType.instance, DecimalType.instance, DoubleType.instance, FloatType.instance, IntegerType.instance, Int32Type.instance, LongType.instance, ShortType.instance, UTF8Type.instance, SimpleDateType.instance, TimestampType.instance});
        this.boost = boost == null ? DEFAULT_BOOST : boost;
    }

    @Override
    protected Integer doBase(String name, Object value) {
        logger.debug("parsing an object with type: " + value.getClass() + " and value: " + value.toString());
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof Date) {
            int ret = SimpleDateSerializer.timeInMillisToDay((long)((Date)value).getTime());
            logger.debug(" returning: " + Integer.toString(ret));
            return ret;
        }
        if (value instanceof String) {
            try {
                return Double.valueOf((String)value).intValue();
            }
            catch (NumberFormatException e) {
                throw new IndexException("Field '%s' with value '%s' can not be parsed as integer", name, value);
            }
        }
        throw new IndexException("Field '%s' requires an integer, but found '%s'", name, value);
    }

    @Override
    public Field indexedField(String name, Integer value) {
        IntField field = new IntField(name, (int)value, STORE);
        field.setBoost(this.boost.floatValue());
        return field;
    }

    @Override
    public Field sortedField(String name, Integer value) {
        return new SortedNumericDocValuesField(name, value.intValue());
    }

    @Override
    public SortField sortField(String name, boolean reverse) {
        return new SortedNumericSortField(name, SortField.Type.INT, reverse);
    }

    @Override
    public String toString() {
        return this.toStringHelper(this).add("boost", (Object)this.boost).toString();
    }
}

