/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.stratio.cassandra.lucene.schema.mapping.SingleColumnMapper;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedSetSortField;
import org.apache.lucene.util.BytesRef;

public abstract class KeywordMapper
extends SingleColumnMapper.SingleFieldMapper<String> {
    static final FieldType FIELD_TYPE = new FieldType();

    KeywordMapper(String field, String column, Boolean validated, AbstractType<?> ... supportedTypes) {
        super(field, column, (Boolean)true, validated, KEYWORD_ANALYZER, String.class, supportedTypes);
    }

    @Override
    public Field indexedField(String name, String value) {
        this.validateTerm(name, new BytesRef(value));
        return new Field(name, value, FIELD_TYPE);
    }

    @Override
    public Field sortedField(String name, String value) {
        BytesRef bytes = new BytesRef(value);
        this.validateTerm(name, bytes);
        return new SortedSetDocValuesField(name, new BytesRef(value));
    }

    @Override
    public final SortField sortField(String name, boolean reverse) {
        return new SortedSetSortField(name, reverse);
    }

    static {
        FIELD_TYPE.setOmitNorms(true);
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
        FIELD_TYPE.setTokenized(true);
        FIELD_TYPE.freeze();
    }
}

