/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.column.Column;
import com.stratio.cassandra.lucene.schema.mapping.SingleColumnMapper;
import java.util.Date;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongMapper
extends SingleColumnMapper.SingleFieldMapper<Long> {
    private static final Logger logger = LoggerFactory.getLogger(LongMapper.class);
    public static final Float DEFAULT_BOOST = Float.valueOf(1.0f);
    public final Float boost;

    public LongMapper(String field, String column, Boolean validated, Float boost) {
        super(field, column, (Boolean)true, validated, null, Long.class, new AbstractType[]{AsciiType.instance, ByteType.instance, DecimalType.instance, DoubleType.instance, FloatType.instance, IntegerType.instance, Int32Type.instance, LongType.instance, ShortType.instance, UTF8Type.instance, SimpleDateType.instance, TimestampType.instance});
        this.boost = boost == null ? DEFAULT_BOOST : boost;
    }

    @Override
    protected Long doBase(String name, Object value) {
        logger.debug("parsing an object with type: " + value.getClass() + " and value: " + value.toString());
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof Date) {
            long ret = ((Date)value).getTime();
            logger.debug("returning: " + Long.toString(ret));
            return ret;
        }
        if (value instanceof String) {
            try {
                return Double.valueOf((String)value).longValue();
            }
            catch (NumberFormatException e) {
                throw new IndexException("Field '%s' with value '%s' can not be parsed as long", name, value);
            }
        }
        throw new IndexException("Field '%s' requires a long, but found '%s'", name, value);
    }

    @Override
    protected <K> Long doBase(Column<K> column) {
        if (column.getType() instanceof SimpleDateType) {
            return SimpleDateType.instance.toTimeInMillis(column.getDecomposedValue());
        }
        return this.doBase(column.getFieldName(this.field), column.getComposedValue());
    }

    @Override
    public Field indexedField(String name, Long value) {
        LongField field = new LongField(name, (long)value, STORE);
        field.setBoost(this.boost.floatValue());
        return field;
    }

    @Override
    public Field sortedField(String name, Long value) {
        return new SortedNumericDocValuesField(name, value);
    }

    @Override
    public SortField sortField(String name, boolean reverse) {
        return new SortedNumericSortField(name, SortField.Type.LONG, reverse);
    }

    @Override
    public String toString() {
        return this.toStringHelper(this).add("boost", (Object)this.boost).toString();
    }
}

