/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.google.common.base.Objects;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.analysis.StandardAnalyzers;
import com.stratio.cassandra.lucene.schema.column.Column;
import com.stratio.cassandra.lucene.schema.column.Columns;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;

public abstract class Mapper {
    static final String KEYWORD_ANALYZER = StandardAnalyzers.KEYWORD.toString();
    public static final Field.Store STORE = Field.Store.NO;
    public static final boolean DEFAULT_VALIDATED = false;
    public final String field;
    public final Boolean docValues;
    public final Boolean validated;
    public final String analyzer;
    public final AbstractType<?>[] supportedTypes;
    public final List<String> mappedColumns;

    protected Mapper(String field, Boolean docValues, Boolean validated, String analyzer, List<String> mappedColumns, AbstractType<?> ... supportedTypes) {
        if (StringUtils.isBlank((CharSequence)field)) {
            throw new IndexException("Field name is required", new Object[0]);
        }
        this.field = field;
        this.docValues = docValues;
        this.validated = validated == null ? false : validated;
        this.analyzer = analyzer;
        this.mappedColumns = mappedColumns;
        this.supportedTypes = supportedTypes;
    }

    public abstract void addFields(Document var1, Columns var2);

    public final void validate(Columns columns) {
        if (this.validated.booleanValue()) {
            this.addFields(new Document(), columns);
        }
    }

    public abstract SortField sortField(String var1, boolean var2);

    protected boolean supports(AbstractType<?> type) {
        AbstractType checkedType = type;
        if (type.isCollection()) {
            if (type instanceof MapType) {
                checkedType = ((MapType)type).getValuesType();
            } else if (type instanceof ListType) {
                checkedType = ((ListType)type).getElementsType();
            } else if (type instanceof SetType) {
                checkedType = ((SetType)type).getElementsType();
            }
            return this.supports(checkedType);
        }
        if (type instanceof ReversedType) {
            ReversedType reversedType = (ReversedType)type;
            checkedType = reversedType.baseType;
        }
        for (AbstractType<?> n : this.supportedTypes) {
            if (checkedType.getClass() != n.getClass()) continue;
            return true;
        }
        return false;
    }

    public final void validate(CFMetaData metadata) {
        for (String column : this.mappedColumns) {
            this.validate(metadata, column);
        }
    }

    private AbstractType<?> findChildType(AbstractType<?> type, String childName) {
        AbstractType parent;
        AbstractType abstractType = parent = type instanceof ReversedType ? ((ReversedType)type).baseType : type;
        if (parent instanceof UserType) {
            UserType userType = (UserType)parent;
            for (int i = 0; i < userType.fieldNames().size(); ++i) {
                if (!userType.fieldNameAsString(i).equals(childName)) continue;
                return userType.fieldType(i);
            }
        } else if (parent instanceof TupleType) {
            TupleType tupleType = (TupleType)parent;
            Integer i = 0;
            while (i < tupleType.size()) {
                if (i.toString().equals(childName)) {
                    return tupleType.type(i.intValue());
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        } else if (parent.isCollection()) {
            CollectionType collType = (CollectionType)parent;
            switch (collType.kind) {
                case SET: {
                    return this.findChildType(collType.nameComparator(), childName);
                }
                case LIST: {
                    return this.findChildType(collType.valueComparator(), childName);
                }
                case MAP: {
                    return this.findChildType(collType.valueComparator(), childName);
                }
            }
        }
        return null;
    }

    private void validateTuple(CFMetaData metadata, String column) {
        String[] names = column.split(Column.UDT_PATTERN);
        int numMatches = names.length;
        ByteBuffer parentColName = UTF8Type.instance.decompose((Object)names[0]);
        ColumnDefinition parentCD = metadata.getColumnDefinition(parentColName);
        if (parentCD == null) {
            throw new IndexException("No column definition '%s' for mapper '%s'", names[0], this.field);
        }
        if (parentCD.isStatic()) {
            throw new IndexException("Lucene indexes are not allowed on static columns as '%s'", column);
        }
        AbstractType<?> actualType = parentCD.type;
        String columnIterator = names[0];
        for (int i = 1; i < names.length; ++i) {
            columnIterator = columnIterator + "." + names[i];
            if ((actualType = this.findChildType(actualType, names[i])) == null) {
                throw new IndexException("No column definition '%s' for mapper '%s'", columnIterator, this.field);
            }
            if (i != numMatches - 1) continue;
            this.validate(actualType, columnIterator);
        }
    }

    private void validate(CFMetaData metadata, String column) {
        if (Column.isTuple(column)) {
            this.validateTuple(metadata, column);
        } else {
            ByteBuffer columnName = UTF8Type.instance.decompose((Object)column);
            ColumnDefinition columnDefinition = metadata.getColumnDefinition(columnName);
            if (columnDefinition == null) {
                throw new IndexException("No column definition '%s' for mapper '%s'", column, this.field);
            }
            this.validate(columnDefinition, column);
        }
    }

    private void validate(ColumnDefinition columnDefinition, String column) {
        if (columnDefinition.isStatic()) {
            throw new IndexException("Lucene indexes are not allowed on static columns as '%s'", column);
        }
        this.validate(columnDefinition.type, column);
    }

    private void validate(AbstractType<?> type, String column) {
        if (!this.supports(type)) {
            throw new IndexException("Type '%s' in column '%s' is not supported by mapper '%s'", type, column, this.field);
        }
    }

    public final boolean maps(Columns columns) {
        for (String columnName : this.mappedColumns) {
            Columns mapperColumns = columns.getColumnsByCellName(columnName);
            if (mapperColumns.isEmpty()) {
                return false;
            }
            for (Column<?> column : mapperColumns) {
                if (!column.isMultiCell()) continue;
                return false;
            }
        }
        return true;
    }

    void validateTerm(String name, BytesRef term) {
        int size = term.length;
        int maxSize = 32766;
        if (size > maxSize) {
            throw new IndexException("Discarding immense term in field='{}', Lucene only allows terms with at most {} bytes in length; got {} bytes: {}...", name, maxSize, size, term.utf8ToString().substring(0, 10));
        }
    }

    protected Objects.ToStringHelper toStringHelper(Object self) {
        return Objects.toStringHelper((Object)self).add("field", (Object)this.field).add("docValues", (Object)this.docValues).add("validated", (Object)this.validated);
    }

    public String toString() {
        return this.toStringHelper(this).toString();
    }
}

