/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.google.common.base.Objects;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.column.Column;
import com.stratio.cassandra.lucene.schema.column.Columns;
import com.stratio.cassandra.lucene.schema.mapping.Mapper;
import java.util.Collections;
import javax.validation.constraints.NotNull;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public abstract class SingleColumnMapper<T extends Comparable<T>>
extends Mapper {
    public final String column;
    public final Class<T> base;

    public SingleColumnMapper(String field, String column, Boolean docValues, Boolean validated, String analyzer, Class<T> base, AbstractType<?> ... supportedTypes) {
        super(field, docValues, validated, analyzer, Collections.singletonList(column == null ? field : column), supportedTypes);
        if (StringUtils.isWhitespace((CharSequence)column)) {
            throw new IndexException("Column must not be whitespace, but found '%s'", column);
        }
        this.column = column == null ? field : column;
        this.base = base;
    }

    public String getColumn() {
        return this.column;
    }

    @Override
    public void addFields(Document document, Columns columns) {
        Columns extractedColumns = columns.getColumnsByMapperName(this.column);
        for (Column<?> column : extractedColumns) {
            this.addFields(document, column);
        }
    }

    private <K> void addFields(Document document, Column<K> c) {
        String name = this.column.equals(this.field) ? c.getFullName() : c.getFieldName(this.field);
        K value = c.getComposedValue();
        if (value != null) {
            T base = this.base(c);
            this.addIndexedFields(document, name, base);
            this.addSortedFields(document, name, base);
        }
    }

    public abstract void addIndexedFields(Document var1, String var2, T var3);

    public abstract void addSortedFields(Document var1, String var2, T var3);

    public final T base(String field, Object value) {
        return value == null ? null : (T)this.doBase(field, value);
    }

    public final <K> T base(Column<K> column) {
        return column.getComposedValue() == null ? null : (T)this.doBase(column);
    }

    protected abstract T doBase(@NotNull String var1, @NotNull Object var2);

    protected <K> T doBase(Column<K> column) {
        return this.doBase(column.getFieldName(this.field), column.getComposedValue());
    }

    @Override
    protected Objects.ToStringHelper toStringHelper(Object self) {
        return super.toStringHelper(self).add("column", (Object)this.column);
    }

    @Override
    public String toString() {
        return this.toStringHelper(this).toString();
    }

    public static abstract class SingleFieldMapper<T extends Comparable<T>>
    extends SingleColumnMapper<T> {
        public SingleFieldMapper(String field, String column, Boolean docValues, Boolean validated, String analyzer, Class<T> base, AbstractType<?> ... supportedTypes) {
            super(field, column, docValues, validated, analyzer, base, supportedTypes);
        }

        @Override
        public void addIndexedFields(Document document, String name, T value) {
            Field field = this.indexedField(name, value);
            if (field != null) {
                document.add(field);
            }
        }

        @Override
        public void addSortedFields(Document document, String name, T value) {
            Field field = this.sortedField(name, value);
            if (field != null) {
                document.add(field);
            }
        }

        public abstract Field indexedField(String var1, T var2);

        public abstract Field sortedField(String var1, T var2);
    }
}

