/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.stratio.cassandra.lucene.schema.mapping.KeywordMapper;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;

public class StringMapper
extends KeywordMapper {
    public static final boolean DEFAULT_CASE_SENSITIVE = true;
    public final boolean caseSensitive;

    public StringMapper(String field, String column, Boolean validated, Boolean caseSensitive) {
        super(field, column, validated, new AbstractType[]{AsciiType.instance, BooleanType.instance, BytesType.instance, ByteType.instance, DoubleType.instance, FloatType.instance, InetAddressType.instance, IntegerType.instance, Int32Type.instance, LongType.instance, ShortType.instance, TimestampType.instance, TimeUUIDType.instance, UTF8Type.instance, UUIDType.instance});
        this.caseSensitive = caseSensitive == null ? true : caseSensitive;
    }

    @Override
    protected String doBase(String name, Object value) {
        String string = value.toString();
        return this.caseSensitive ? string : string.toLowerCase();
    }

    @Override
    public String toString() {
        return this.toStringHelper(this).add("caseSensitive", this.caseSensitive).toString();
    }
}

