/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.google.common.primitives.Longs;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.KeywordMapper;
import com.stratio.cassandra.lucene.util.ByteBufferUtils;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;

public class UUIDMapper
extends KeywordMapper {
    public UUIDMapper(String field, String column, Boolean validated) {
        super(field, column, validated, new AbstractType[]{UTF8Type.instance, UUIDType.instance, TimeUUIDType.instance});
    }

    @Override
    protected String doBase(String name, Object value) {
        if (value instanceof UUID) {
            UUID uuid = (UUID)value;
            return UUIDMapper.serialize(uuid);
        }
        if (value instanceof String) {
            try {
                String string = (String)value;
                UUID uuid = UUID.fromString(string);
                return UUIDMapper.serialize(uuid);
            }
            catch (IllegalArgumentException e) {
                throw new IndexException(e, "Field '%s' with value '%s' can not be parsed as UUID", name, value);
            }
        }
        throw new IndexException("Field '%s' requires an UUID, but found '%s'", name, value);
    }

    static String serialize(UUID uuid) {
        StringBuilder sb = new StringBuilder();
        ByteBuffer bb = UUIDType.instance.decompose((Object)uuid);
        int version = bb.get(bb.position() + 6) >> 4 & 0xF;
        sb.append(ByteBufferUtils.toHex((byte)version));
        if (version == 1) {
            long timestamp = uuid.timestamp();
            String timestampHex = ByteBufferUtils.toHex(Longs.toByteArray((long)timestamp));
            sb.append(timestampHex);
        }
        sb.append(ByteBufferUtils.toHex(bb));
        return sb.toString();
    }
}

