/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search;

import com.google.common.base.Objects;
import com.stratio.cassandra.lucene.schema.Schema;
import com.stratio.cassandra.lucene.search.condition.Condition;
import com.stratio.cassandra.lucene.search.sort.Sort;
import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;

public class Search {
    private static final boolean DEFAULT_FORCE_REFRESH = false;
    private final Condition queryCondition;
    private final Condition filterCondition;
    private final Sort sort;
    private final Boolean refresh;

    public Search(Condition queryCondition, Condition filterCondition, Sort sort, Boolean refresh) {
        this.queryCondition = queryCondition;
        this.filterCondition = filterCondition;
        this.sort = sort;
        this.refresh = refresh == null ? false : refresh;
    }

    public boolean requiresFullScan() {
        return this.usesRelevance() || this.usesSorting() || this.refresh != false && this.isEmpty();
    }

    public boolean usesRelevance() {
        return this.queryCondition != null;
    }

    public boolean usesSorting() {
        return this.sort != null;
    }

    public boolean isEmpty() {
        return this.queryCondition == null && this.filterCondition == null && this.sort == null;
    }

    public Sort getSort() {
        return this.sort;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public List<SortField> sortFields(Schema schema) {
        return this.sort == null ? null : this.sort.sortFields(schema);
    }

    public Query query(Schema schema) {
        return this.queryCondition == null ? null : this.queryCondition.query(schema);
    }

    public Query filter(Schema schema) {
        return this.filterCondition == null ? null : this.filterCondition.query(schema);
    }

    public void validate(Schema schema) {
        if (this.queryCondition != null) {
            this.query(schema);
        }
        if (this.filterCondition != null) {
            this.filter(schema);
        }
        if (this.sort != null) {
            this.sort.sortFields(schema);
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("queryCondition", (Object)this.queryCondition).add("filterCondition", (Object)this.filterCondition).add("sort", (Object)this.sort).toString();
    }
}

