/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.search.Search;
import com.stratio.cassandra.lucene.search.condition.Condition;
import com.stratio.cassandra.lucene.search.condition.builder.ConditionBuilder;
import com.stratio.cassandra.lucene.search.sort.Sort;
import com.stratio.cassandra.lucene.search.sort.builder.SortBuilder;
import com.stratio.cassandra.lucene.search.sort.builder.SortFieldBuilder;
import com.stratio.cassandra.lucene.util.Builder;
import com.stratio.cassandra.lucene.util.JsonSerializer;
import java.io.IOException;
import org.codehaus.jackson.annotate.JsonProperty;

public class SearchBuilder
implements Builder<Search> {
    @JsonProperty(value="query")
    private ConditionBuilder<?, ?> queryBuilder;
    @JsonProperty(value="filter")
    private ConditionBuilder<?, ?> filterBuilder;
    @JsonProperty(value="sort")
    private SortBuilder sortBuilder;
    @JsonProperty(value="refresh")
    private boolean refresh;

    public SearchBuilder query(ConditionBuilder<?, ?> queryBuilder) {
        this.queryBuilder = queryBuilder;
        return this;
    }

    public SearchBuilder filter(ConditionBuilder<?, ?> filterBuilder) {
        this.filterBuilder = filterBuilder;
        return this;
    }

    public SearchBuilder sort(SortBuilder sortBuilder) {
        this.sortBuilder = sortBuilder;
        return this;
    }

    public SearchBuilder sort(SortFieldBuilder ... sortFieldBuilders) {
        this.sortBuilder = new SortBuilder(sortFieldBuilders);
        return this;
    }

    public SearchBuilder refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    @Override
    public Search build() {
        Object query = this.queryBuilder == null ? null : this.queryBuilder.build();
        Object filter = this.filterBuilder == null ? null : this.filterBuilder.build();
        Sort sort = this.sortBuilder == null ? null : this.sortBuilder.build();
        return new Search((Condition)query, (Condition)filter, sort, this.refresh);
    }

    public String toJson() {
        this.build();
        try {
            return JsonSerializer.toString(this);
        }
        catch (IOException e) {
            throw new IndexException(e, "Unformateable JSON search: %s", e.getMessage());
        }
    }

    public static SearchBuilder fromJson(String json) {
        try {
            return JsonSerializer.fromString(json, SearchBuilder.class);
        }
        catch (IOException e) {
            throw new IndexException(e, "Unparseable JSON search: %s", e.getMessage());
        }
    }
}

