/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search;

import com.stratio.cassandra.lucene.search.SearchBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.AllConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.BitemporalConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.BooleanConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.ConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.ContainsConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.DateRangeConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.FuzzyConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.GeoBBoxConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.GeoDistanceConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.GeoShapeConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.LuceneConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.MatchConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.NoneConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.PhraseConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.PrefixConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.RangeConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.RegexpConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.WildcardConditionBuilder;
import com.stratio.cassandra.lucene.search.sort.builder.GeoDistanceSortFieldBuilder;
import com.stratio.cassandra.lucene.search.sort.builder.SimpleSortFieldBuilder;
import com.stratio.cassandra.lucene.search.sort.builder.SortFieldBuilder;

public final class SearchBuilders {
    private SearchBuilders() {
    }

    public static SearchBuilder search() {
        return new SearchBuilder();
    }

    public static SearchBuilder query(ConditionBuilder<?, ?> query) {
        return SearchBuilders.search().query(query);
    }

    public static SearchBuilder filter(ConditionBuilder<?, ?> filter) {
        return SearchBuilders.search().filter(filter);
    }

    public static SearchBuilder sort(SortFieldBuilder ... sortFields) {
        return SearchBuilders.search().sort(sortFields);
    }

    public static BooleanConditionBuilder bool() {
        return new BooleanConditionBuilder();
    }

    public static AllConditionBuilder all() {
        return new AllConditionBuilder();
    }

    public static FuzzyConditionBuilder fuzzy(String field, String value) {
        return new FuzzyConditionBuilder(field, value);
    }

    public static LuceneConditionBuilder lucene(String query) {
        return new LuceneConditionBuilder(query);
    }

    public static MatchConditionBuilder match(String field, Object value) {
        return new MatchConditionBuilder(field, value);
    }

    public static ContainsConditionBuilder contains(String field, Object ... values) {
        return new ContainsConditionBuilder(field, values);
    }

    public static NoneConditionBuilder none() {
        return new NoneConditionBuilder();
    }

    public static PhraseConditionBuilder phrase(String field, String value) {
        return new PhraseConditionBuilder(field, value);
    }

    public static PrefixConditionBuilder prefix(String field, String value) {
        return new PrefixConditionBuilder(field, value);
    }

    public static RangeConditionBuilder range(String field) {
        return new RangeConditionBuilder(field);
    }

    public static RegexpConditionBuilder regexp(String field, String value) {
        return new RegexpConditionBuilder(field, value);
    }

    public static WildcardConditionBuilder wildcard(String field, String value) {
        return new WildcardConditionBuilder(field, value);
    }

    public static GeoBBoxConditionBuilder geoBBox(String field, double minLongitude, double maxLongitude, double minLatitude, double maxLatitude) {
        return new GeoBBoxConditionBuilder(field, minLatitude, maxLatitude, minLongitude, maxLongitude);
    }

    public static GeoDistanceConditionBuilder geoDistance(String field, double latitude, double longitude, String maxDistance) {
        return new GeoDistanceConditionBuilder(field, latitude, longitude, maxDistance);
    }

    public static GeoShapeConditionBuilder geoShape(String field, String shape) {
        return new GeoShapeConditionBuilder(field, shape);
    }

    public static DateRangeConditionBuilder dateRange(String field) {
        return new DateRangeConditionBuilder(field);
    }

    public static SimpleSortFieldBuilder field(String field) {
        return new SimpleSortFieldBuilder(field);
    }

    public static GeoDistanceSortFieldBuilder geoDistanceSortField(String mapper, double latitude, double longitude) {
        return new GeoDistanceSortFieldBuilder(mapper, latitude, longitude);
    }

    public static BitemporalConditionBuilder bitemporalSearch(String field) {
        return new BitemporalConditionBuilder(field);
    }
}

