/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition;

import com.google.common.base.Objects;
import com.stratio.cassandra.lucene.schema.Schema;
import com.stratio.cassandra.lucene.search.condition.Condition;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanCondition
extends Condition {
    private static final Logger logger = LoggerFactory.getLogger(BooleanCondition.class);
    public final List<Condition> must;
    public final List<Condition> should;
    public final List<Condition> not;

    public BooleanCondition(Float boost, List<Condition> must, List<Condition> should, List<Condition> not) {
        super(boost);
        this.must = must == null ? new LinkedList() : must;
        this.should = should == null ? new LinkedList() : should;
        this.not = not == null ? new LinkedList() : not;
    }

    @Override
    public Query doQuery(Schema schema) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (Condition condition : this.must) {
            builder.add(condition.query(schema), BooleanClause.Occur.MUST);
        }
        for (Condition condition : this.should) {
            builder.add(condition.query(schema), BooleanClause.Occur.SHOULD);
        }
        for (Condition condition : this.not) {
            builder.add(condition.query(schema), BooleanClause.Occur.MUST_NOT);
        }
        if (this.must.isEmpty() && this.should.isEmpty() && !this.not.isEmpty()) {
            logger.warn("Performing resource-intensive pure negation search");
            builder.add(new MatchAllDocsQuery(), BooleanClause.Occur.FILTER);
        }
        return builder.build();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("boost", (Object)this.boost).add("must", this.must).add("should", this.should).add("not", this.not).toString();
    }
}

