/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition;

import com.google.common.base.Objects;
import com.stratio.cassandra.lucene.schema.Schema;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Condition {
    protected static final Logger logger = LoggerFactory.getLogger(Condition.class);
    public final Float boost;

    public Condition(Float boost) {
        this.boost = boost;
    }

    public final Query query(Schema schema) {
        Query query = this.doQuery(schema);
        return this.boost == null ? query : new BoostQuery(query, this.boost.floatValue());
    }

    public abstract Query doQuery(Schema var1);

    static BytesRef docValue(String value) {
        return value == null ? null : new BytesRef(value);
    }

    static Long docValue(Long value) {
        return value == null ? null : value;
    }

    static Long docValue(Integer value) {
        return value == null ? null : Long.valueOf(value.longValue());
    }

    static Long docValue(Float value) {
        return value == null ? null : Condition.docValue(NumericUtils.floatToSortableInt(value.floatValue()));
    }

    static Long docValue(Double value) {
        return value == null ? null : Long.valueOf(NumericUtils.doubleToSortableLong(value));
    }

    protected Objects.ToStringHelper toStringHelper(Object o) {
        return Objects.toStringHelper((Object)o).add("boost", (Object)this.boost);
    }
}

