/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition;

import com.google.common.base.Objects;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.SingleColumnMapper;
import com.stratio.cassandra.lucene.search.condition.MatchCondition;
import com.stratio.cassandra.lucene.search.condition.SingleColumnCondition;
import java.util.Arrays;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public class ContainsCondition
extends SingleColumnCondition {
    public static final boolean DEFAULT_DOC_VALUES = false;
    public final String field;
    public final Object[] values;
    public final boolean docValues;

    public ContainsCondition(Float boost, String field, Boolean docValues, Object ... values) {
        super(boost, field);
        if (values == null || values.length == 0) {
            throw new IndexException("Field values required", new Object[0]);
        }
        this.field = field;
        this.docValues = docValues == null ? false : docValues;
        this.values = values;
    }

    @Override
    public Query query(SingleColumnMapper<?> mapper, Analyzer analyzer) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (Object value : this.values) {
            MatchCondition condition = new MatchCondition(this.boost, this.field, value, this.docValues);
            builder.add(condition.query(mapper, analyzer), BooleanClause.Occur.SHOULD);
        }
        return builder.build();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("boost", (Object)this.boost).add("field", (Object)this.field).add("values", (Object)Arrays.toString(this.values)).add("docValues", this.docValues).toString();
    }
}

