/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.DateRangeMapper;
import com.stratio.cassandra.lucene.search.condition.SingleMapperCondition;
import java.util.Date;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.prefix.NumberRangePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.NumberRangePrefixTree;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;

public class DateRangeCondition
extends SingleMapperCondition<DateRangeMapper> {
    public static final long DEFAULT_FROM = 0L;
    public static final long DEFAULT_TO = Long.MAX_VALUE;
    public static final String DEFAULT_OPERATION = "intersects";
    public final Object from;
    public final Object to;
    public final String operation;

    public DateRangeCondition(Float boost, String field, Object from, Object to, String operation) {
        super(boost, field, DateRangeMapper.class);
        this.from = from == null ? Long.valueOf(0L) : from;
        this.to = to == null ? Long.valueOf(Long.MAX_VALUE) : to;
        this.operation = operation == null ? DEFAULT_OPERATION : operation;
    }

    @Override
    public Query query(DateRangeMapper mapper, Analyzer analyzer) {
        NumberRangePrefixTreeStrategy strategy = mapper.strategy;
        Date fromDate = mapper.base(this.from);
        Date toDate = mapper.base(this.to);
        NumberRangePrefixTree.NRShape shape = mapper.makeShape(fromDate, toDate);
        SpatialOperation spatialOperation = DateRangeCondition.parseSpatialOperation(this.operation);
        SpatialArgs args = new SpatialArgs(spatialOperation, shape);
        return ((SpatialStrategy)strategy).makeQuery(args);
    }

    static SpatialOperation parseSpatialOperation(String operation) {
        if (operation == null) {
            throw new IndexException("Operation is required", new Object[0]);
        }
        if (operation.equalsIgnoreCase("is_within")) {
            return SpatialOperation.IsWithin;
        }
        if (operation.equalsIgnoreCase("contains")) {
            return SpatialOperation.Contains;
        }
        if (operation.equalsIgnoreCase(DEFAULT_OPERATION)) {
            return SpatialOperation.Intersects;
        }
        throw new IndexException("Operation is invalid: " + operation, new Object[0]);
    }

    public String toString() {
        return this.toStringHelper(this).add("from", this.from).add("to", this.to).add("operation", (Object)this.operation).toString();
    }
}

