/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.SingleColumnMapper;
import com.stratio.cassandra.lucene.search.condition.SingleColumnCondition;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.Query;

public class FuzzyCondition
extends SingleColumnCondition {
    public static final int DEFAULT_MAX_EDITS = 2;
    public static final int DEFAULT_PREFIX_LENGTH = 0;
    public static final int DEFAULT_MAX_EXPANSIONS = 50;
    public static final boolean DEFAULT_TRANSPOSITIONS = true;
    public final String value;
    public final int maxEdits;
    public final int prefixLength;
    public final int maxExpansions;
    public final boolean transpositions;

    public FuzzyCondition(Float boost, String field, String value, Integer maxEdits, Integer prefixLength, Integer maxExpansions, Boolean transpositions) {
        super(boost, field);
        this.value = FuzzyCondition.validateValue(value);
        this.maxEdits = FuzzyCondition.validateMaxEdits(maxEdits);
        this.prefixLength = FuzzyCondition.validatePrefixLength(prefixLength);
        this.maxExpansions = FuzzyCondition.validateMaxExpansions(maxExpansions);
        this.transpositions = FuzzyCondition.validateTranspositions(transpositions);
    }

    private static String validateValue(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IndexException("Field value required", new Object[0]);
        }
        return value;
    }

    private static Integer validateMaxEdits(Integer maxEdits) {
        if (maxEdits == null) {
            return 2;
        }
        if (maxEdits < 0 || maxEdits > 2) {
            throw new IndexException("max_edits must be between 0 and 2", new Object[0]);
        }
        return maxEdits;
    }

    private static Integer validatePrefixLength(Integer prefixLength) {
        if (prefixLength == null) {
            return 0;
        }
        if (prefixLength < 0) {
            throw new IndexException("prefix_length must be positive.", new Object[0]);
        }
        return prefixLength;
    }

    private static Integer validateMaxExpansions(Integer maxExpansions) {
        if (maxExpansions == null) {
            return 50;
        }
        if (maxExpansions < 0) {
            throw new IndexException("max_expansions must be positive.", new Object[0]);
        }
        return maxExpansions;
    }

    private static Boolean validateTranspositions(Boolean transpositions) {
        if (transpositions == null) {
            return true;
        }
        return transpositions;
    }

    @Override
    public Query query(SingleColumnMapper<?> mapper, Analyzer analyzer) {
        if (mapper.base == String.class) {
            Term term = new Term(this.field, this.value);
            return new FuzzyQuery(term, this.maxEdits, this.prefixLength, this.maxExpansions, this.transpositions);
        }
        throw new IndexException("Fuzzy queries are not supported by mapper %s", mapper);
    }

    public String toString() {
        return this.toStringHelper(this).add("value", (Object)this.value).add("maxEdits", this.maxEdits).add("prefixLength", this.prefixLength).add("maxExpansions", this.maxExpansions).add("transpositions", this.transpositions).toString();
    }
}

