/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition;

import com.spatial4j.core.shape.Rectangle;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.GeoPointMapper;
import com.stratio.cassandra.lucene.search.condition.SingleMapperCondition;
import com.stratio.cassandra.lucene.util.GeospatialUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;

public class GeoBBoxCondition
extends SingleMapperCondition<GeoPointMapper> {
    public final double minLatitude;
    public final double maxLatitude;
    public final double minLongitude;
    public final double maxLongitude;

    public GeoBBoxCondition(Float boost, String field, Double minLatitude, Double maxLatitude, Double minLongitude, Double maxLongitude) {
        super(boost, field, GeoPointMapper.class);
        this.minLatitude = GeoPointMapper.checkLatitude("min_latitude", minLatitude);
        this.maxLatitude = GeoPointMapper.checkLatitude("max_latitude", maxLatitude);
        this.minLongitude = GeoPointMapper.checkLongitude("min_longitude", minLongitude);
        this.maxLongitude = GeoPointMapper.checkLongitude("max_longitude", maxLongitude);
        if (minLongitude > maxLongitude) {
            throw new IndexException("min_longitude must be lower than max_longitude", new Object[0]);
        }
        if (minLatitude > maxLatitude) {
            throw new IndexException("min_latitude must be lower than max_latitude", new Object[0]);
        }
    }

    @Override
    public Query query(GeoPointMapper mapper, Analyzer analyzer) {
        SpatialStrategy spatialStrategy = mapper.bboxStrategy;
        Rectangle rectangle = GeospatialUtils.CONTEXT.makeRectangle(this.minLongitude, this.maxLongitude, this.minLatitude, this.maxLatitude);
        SpatialArgs args = new SpatialArgs(SpatialOperation.BBoxIntersects, rectangle);
        return spatialStrategy.makeQuery(args);
    }

    public String toString() {
        return this.toStringHelper(this).add("minLatitude", this.minLatitude).add("maxLatitude", this.maxLatitude).add("minLongitude", this.minLongitude).add("maxLongitude", this.maxLongitude).toString();
    }
}

