/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition;

import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.shape.Circle;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.common.GeoDistance;
import com.stratio.cassandra.lucene.common.GeoDistanceUnit;
import com.stratio.cassandra.lucene.schema.mapping.GeoPointMapper;
import com.stratio.cassandra.lucene.search.condition.SingleMapperCondition;
import com.stratio.cassandra.lucene.util.GeospatialUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;

public class GeoDistanceCondition
extends SingleMapperCondition<GeoPointMapper> {
    public final double latitude;
    public final double longitude;
    public final GeoDistance minGeoDistance;
    public final GeoDistance maxGeoDistance;

    public GeoDistanceCondition(Float boost, String field, Double latitude, Double longitude, GeoDistance minGeoDistance, GeoDistance maxGeoDistance) {
        super(boost, field, GeoPointMapper.class);
        this.latitude = GeoPointMapper.checkLatitude("latitude", latitude);
        this.longitude = GeoPointMapper.checkLongitude("longitude", longitude);
        if (maxGeoDistance == null) {
            throw new IndexException("max_distance must be provided", new Object[0]);
        }
        this.maxGeoDistance = maxGeoDistance;
        this.minGeoDistance = minGeoDistance;
        if (minGeoDistance != null && minGeoDistance.compareTo(maxGeoDistance) >= 0) {
            throw new IndexException("min_distance must be lower than max_distance", new Object[0]);
        }
    }

    @Override
    public Query query(GeoPointMapper mapper, Analyzer analyzer) {
        SpatialStrategy spatialStrategy = mapper.distanceStrategy;
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(this.query(this.maxGeoDistance, spatialStrategy), BooleanClause.Occur.FILTER);
        if (this.minGeoDistance != null) {
            builder.add(this.query(this.minGeoDistance, spatialStrategy), BooleanClause.Occur.MUST_NOT);
        }
        return builder.build();
    }

    private Query query(GeoDistance geoDistance, SpatialStrategy spatialStrategy) {
        double kms = geoDistance.getValue(GeoDistanceUnit.KILOMETRES);
        double distance = DistanceUtils.dist2Degrees(kms, 6371.0087714);
        Circle circle = GeospatialUtils.CONTEXT.makeCircle(this.longitude, this.latitude, distance);
        SpatialArgs args = new SpatialArgs(SpatialOperation.Intersects, circle);
        return spatialStrategy.makeQuery(args);
    }

    public String toString() {
        return this.toStringHelper(this).add("latitude", this.latitude).add("longitude", this.longitude).add("minGeoDistance", (Object)this.minGeoDistance).add("maxGeoDistance", (Object)this.maxGeoDistance).toString();
    }
}

