/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition;

import com.spatial4j.core.shape.jts.JtsGeometry;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.common.GeoOperation;
import com.stratio.cassandra.lucene.common.GeoTransformation;
import com.stratio.cassandra.lucene.schema.Schema;
import com.stratio.cassandra.lucene.schema.mapping.GeoPointMapper;
import com.stratio.cassandra.lucene.schema.mapping.GeoShapeMapper;
import com.stratio.cassandra.lucene.schema.mapping.Mapper;
import com.stratio.cassandra.lucene.search.condition.SingleFieldCondition;
import com.stratio.cassandra.lucene.util.GeospatialUtilsJTS;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;

public class GeoShapeCondition
extends SingleFieldCondition {
    public static final GeoOperation DEFAULT_OPERATION = GeoOperation.IS_WITHIN;
    public final JtsGeometry geometry;
    public final GeoOperation operation;
    public final List<GeoTransformation> transformations;

    public GeoShapeCondition(Float boost, String field, String shape, GeoOperation operation, List<GeoTransformation> transformations) {
        super(boost, field);
        this.geometry = GeospatialUtilsJTS.geometry(shape);
        this.operation = operation == null ? DEFAULT_OPERATION : operation;
        this.transformations = transformations == null ? Collections.emptyList() : transformations;
    }

    @Override
    public Query doQuery(Schema schema) {
        SpatialStrategy strategy;
        Mapper mapper = schema.getMapper(this.field);
        if (mapper == null) {
            throw new IndexException("No mapper found for field '%s'", this.field);
        }
        if (mapper instanceof GeoShapeMapper) {
            strategy = ((GeoShapeMapper)mapper).strategy;
        } else if (mapper instanceof GeoPointMapper) {
            strategy = ((GeoPointMapper)mapper).distanceStrategy;
        } else {
            throw new IndexException("'geo_shape' search requires a mapper of type 'geo_point' or 'geo_shape' but found %s:%s", this.field, mapper);
        }
        JtsGeometry transformedGeometry = this.geometry;
        if (this.transformations != null) {
            for (GeoTransformation transformation : this.transformations) {
                transformedGeometry = transformation.apply(transformedGeometry);
            }
        }
        SpatialArgs args = new SpatialArgs(this.operation.getSpatialOperation(), transformedGeometry);
        args.setDistErr(0.0);
        return strategy.makeQuery(args);
    }

    public String toString() {
        return this.toStringHelper(this).add("geometry", (Object)this.geometry).add("operation", (Object)this.operation).add("transformations", this.transformations).toString();
    }
}

