/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition;

import com.google.common.base.Objects;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.Schema;
import com.stratio.cassandra.lucene.search.condition.Condition;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;

public class LuceneCondition
extends Condition {
    public static final String DEFAULT_FIELD = "lucene";
    public final String query;
    public final String defaultField;

    public LuceneCondition(Float boost, String defaultField, String query) {
        super(boost);
        if (StringUtils.isBlank((CharSequence)query)) {
            throw new IndexException("Query statement required", new Object[0]);
        }
        this.query = query;
        this.defaultField = defaultField == null ? DEFAULT_FIELD : defaultField;
    }

    @Override
    public Query doQuery(Schema schema) {
        try {
            Analyzer analyzer = schema.getAnalyzer();
            QueryParser queryParser = new QueryParser(this.defaultField, analyzer);
            queryParser.setAllowLeadingWildcard(true);
            queryParser.setLowercaseExpandedTerms(false);
            return queryParser.parse(this.query);
        }
        catch (ParseException e) {
            throw new IndexException("Error while parsing lucene syntax query: %s", e.getMessage());
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("query", (Object)this.query).add("defaultField", (Object)this.defaultField).toString();
    }
}

