/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.SingleColumnMapper;
import com.stratio.cassandra.lucene.search.condition.SingleColumnCondition;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;

public class RegexpCondition
extends SingleColumnCondition {
    public final String value;

    public RegexpCondition(Float boost, String field, String value) {
        super(boost, field);
        if (value == null) {
            throw new IndexException("Field value required", new Object[0]);
        }
        this.value = value;
    }

    @Override
    public Query query(SingleColumnMapper<?> mapper, Analyzer analyzer) {
        if (mapper.base == String.class) {
            Term term = new Term(this.field, this.value);
            return new RegexpQuery(term);
        }
        throw new IndexException("Regexp queries are not supported by mapper '%s'", mapper);
    }

    public String toString() {
        return this.toStringHelper(this).add("value", (Object)this.value).toString();
    }
}

