/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.Schema;
import com.stratio.cassandra.lucene.schema.mapping.Mapper;
import com.stratio.cassandra.lucene.schema.mapping.SingleColumnMapper;
import com.stratio.cassandra.lucene.search.condition.SingleFieldCondition;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;

public abstract class SingleColumnCondition
extends SingleFieldCondition {
    public SingleColumnCondition(Float boost, String field) {
        super(boost, field);
    }

    @Override
    public final Query doQuery(Schema schema) {
        Mapper mapper = schema.getMapper(this.field);
        if (mapper == null) {
            throw new IndexException("No mapper found for field '%s'", this.field);
        }
        if (!SingleColumnMapper.class.isAssignableFrom(mapper.getClass())) {
            throw new IndexException("Field '%s' requires a mapper of type '%s' but found '%s'", this.field, SingleColumnMapper.class.getSimpleName(), mapper);
        }
        return this.query((SingleColumnMapper)mapper, schema.getAnalyzer());
    }

    public abstract Query query(SingleColumnMapper<?> var1, Analyzer var2);
}

