/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.Schema;
import com.stratio.cassandra.lucene.schema.mapping.Mapper;
import com.stratio.cassandra.lucene.search.condition.SingleFieldCondition;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;

public abstract class SingleMapperCondition<T extends Mapper>
extends SingleFieldCondition {
    protected final Class<? extends T> type;

    protected SingleMapperCondition(Float boost, String field, Class<? extends T> type) {
        super(boost, field);
        this.type = type;
    }

    @Override
    public Query doQuery(Schema schema) {
        Mapper mapper = schema.getMapper(this.field);
        if (mapper == null) {
            throw new IndexException("No mapper found for field '%s'", this.field);
        }
        if (!this.type.isAssignableFrom(mapper.getClass())) {
            throw new IndexException("Field '%s' requires a mapper of type '%s' but found '%s'", this.field, this.type, mapper);
        }
        return this.query(mapper, schema.getAnalyzer());
    }

    public abstract Query query(T var1, Analyzer var2);
}

