/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition.builder;

import com.stratio.cassandra.lucene.common.GeoOperation;
import com.stratio.cassandra.lucene.common.GeoTransformation;
import com.stratio.cassandra.lucene.common.JTSNotFoundException;
import com.stratio.cassandra.lucene.search.condition.GeoShapeCondition;
import com.stratio.cassandra.lucene.search.condition.builder.ConditionBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class GeoShapeConditionBuilder
extends ConditionBuilder<GeoShapeCondition, GeoShapeConditionBuilder> {
    @JsonProperty(value="field")
    private final String field;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="operation")
    private String operation;
    @JsonProperty(value="transformations")
    private List<GeoTransformation> transformations = new ArrayList<GeoTransformation>();

    @JsonCreator
    public GeoShapeConditionBuilder(@JsonProperty(value="field") String field, @JsonProperty(value="shape") String shape) {
        this.field = field;
        this.shape = shape;
    }

    public GeoShapeConditionBuilder operation(String operation) {
        this.operation = operation;
        return this;
    }

    public GeoShapeConditionBuilder transformations(List<GeoTransformation> transformations) {
        this.transformations = transformations;
        return this;
    }

    @Override
    public GeoShapeCondition build() {
        GeoOperation geoOperation;
        GeoOperation geoOperation2 = geoOperation = StringUtils.isBlank((CharSequence)this.operation) ? null : GeoOperation.parse(this.operation);
        if (this.transformations == null) {
            this.transformations = new ArrayList<GeoTransformation>();
        }
        try {
            return new GeoShapeCondition(this.boost, this.field, this.shape, geoOperation, this.transformations);
        }
        catch (NoClassDefFoundError e) {
            throw new JTSNotFoundException();
        }
    }
}

