/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.sort;

import com.google.common.base.Objects;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.shape.Point;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.Schema;
import com.stratio.cassandra.lucene.schema.column.Columns;
import com.stratio.cassandra.lucene.schema.mapping.GeoPointMapper;
import com.stratio.cassandra.lucene.schema.mapping.Mapper;
import com.stratio.cassandra.lucene.search.sort.SortField;
import com.stratio.cassandra.lucene.util.GeospatialUtils;
import java.util.Comparator;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.spatial.SpatialStrategy;

public class GeoDistanceSortField
extends SortField {
    public final String field;
    public final double longitude;
    public final double latitude;

    public GeoDistanceSortField(String field, Boolean reverse, double latitude, double longitude) {
        super(reverse);
        if (field == null || StringUtils.isBlank((CharSequence)field)) {
            throw new IndexException("Mapper name required", new Object[0]);
        }
        this.field = field;
        this.latitude = GeoPointMapper.checkLatitude("latitude", latitude);
        this.longitude = GeoPointMapper.checkLongitude("longitude", longitude);
    }

    @Override
    public org.apache.lucene.search.SortField sortField(Schema schema) {
        Mapper mapper = schema.getMapper(this.field);
        if (mapper == null) {
            throw new IndexException("Field '%s' is not found", this.field);
        }
        if (!(mapper instanceof GeoPointMapper)) {
            throw new IndexException("Field '%s' type is not geo_point", this.field);
        }
        GeoPointMapper geoPointMapper = (GeoPointMapper)mapper;
        SpatialStrategy strategy = geoPointMapper.distanceStrategy;
        Point pt = GeospatialUtils.CONTEXT.makePoint(this.longitude, this.latitude);
        ValueSource valueSource = strategy.makeDistanceValueSource(pt, 111.19507973436875);
        return valueSource.getSortField(this.reverse);
    }

    @Override
    public Comparator<Columns> comparator(Schema schema) {
        final Mapper mapper = schema.getMapper(this.field);
        return new Comparator<Columns>(){

            @Override
            public int compare(Columns o1, Columns o2) {
                return GeoDistanceSortField.this.compare((GeoPointMapper)mapper, o1, o2);
            }
        };
    }

    protected int compare(GeoPointMapper mapper, Columns o1, Columns o2) {
        if (o1 == null) {
            return o2 == null ? 0 : 1;
        }
        if (o2 == null) {
            return -1;
        }
        Double longO1 = mapper.readLongitude(o1);
        Double latO1 = mapper.readLatitude(o1);
        Double longO2 = mapper.readLongitude(o2);
        Double latO2 = mapper.readLatitude(o2);
        Double base1 = this.distance(longO1, latO1);
        Double base2 = this.distance(longO2, latO2);
        return this.compare(base1, base2);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("field", (Object)this.field).add("reverse", this.reverse).add("latitude", this.latitude).add("longitude", this.longitude).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoDistanceSortField other = (GeoDistanceSortField)o;
        return this.reverse == other.reverse && this.field.equals(other.field) && this.longitude == other.longitude && this.latitude == other.latitude;
    }

    @Override
    public int hashCode() {
        int result = this.field.hashCode();
        result = 31 * result + (this.reverse ? 1 : 0);
        result = 31 * result + new Double(this.latitude).hashCode();
        result = 31 * result + new Double(this.longitude).hashCode();
        return result;
    }

    private Double distance(Double oLon, Double oLat) {
        if (oLon == null || oLat == null) {
            return null;
        }
        return DistanceUtils.distHaversineRAD(DistanceUtils.toRadians(this.latitude), DistanceUtils.toRadians(this.longitude), DistanceUtils.toRadians(oLat), DistanceUtils.toRadians(oLon));
    }
}

