/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.sort;

import com.google.common.base.Objects;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.Schema;
import com.stratio.cassandra.lucene.schema.column.Column;
import com.stratio.cassandra.lucene.schema.column.Columns;
import com.stratio.cassandra.lucene.schema.mapping.Mapper;
import com.stratio.cassandra.lucene.schema.mapping.SingleColumnMapper;
import com.stratio.cassandra.lucene.search.sort.SortField;
import java.util.Comparator;
import org.apache.commons.lang3.StringUtils;

public class SimpleSortField
extends SortField {
    public final String field;

    public SimpleSortField(String field, Boolean reverse) {
        super(reverse);
        if (field == null || StringUtils.isBlank((CharSequence)field)) {
            throw new IndexException("Field name required", new Object[0]);
        }
        this.field = field;
    }

    public String getField() {
        return this.field;
    }

    @Override
    public org.apache.lucene.search.SortField sortField(Schema schema) {
        if (this.field.equalsIgnoreCase("score")) {
            return org.apache.lucene.search.SortField.FIELD_SCORE;
        }
        Mapper mapper = schema.getMapper(this.field);
        if (mapper == null) {
            throw new IndexException("No mapper found for sortFields field '%s'", this.field);
        }
        if (!mapper.docValues.booleanValue()) {
            throw new IndexException("Mapper '%s' is not docValues", mapper.field);
        }
        return mapper.sortField(this.field, this.reverse);
    }

    @Override
    public Comparator<Columns> comparator(Schema schema) {
        final SingleColumnMapper mapper = schema.getSingleColumnMapper(this.field);
        return new Comparator<Columns>(){

            @Override
            public int compare(Columns o1, Columns o2) {
                return SimpleSortField.this.compare(mapper, o1, o2);
            }
        };
    }

    protected int compare(SingleColumnMapper mapper, Columns o1, Columns o2) {
        if (o1 == null) {
            return o2 == null ? 0 : 1;
        }
        if (o2 == null) {
            return -1;
        }
        String column = this.field;
        if (this.field.startsWith(mapper.field)) {
            column = this.field.replaceFirst(mapper.field, mapper.column);
        }
        Column<?> column1 = o1.getColumnsByFullName(column).getFirst();
        Column<?> column2 = o2.getColumnsByFullName(column).getFirst();
        Comparable base1 = column1 == null ? null : (Comparable)mapper.base(column, column1.getComposedValue());
        Comparable base2 = column2 == null ? null : (Comparable)mapper.base(column, column2.getComposedValue());
        return this.compare(base1, base2);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("field", (Object)this.field).add("reverse", this.reverse).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleSortField otherSimpleSortField = (SimpleSortField)o;
        return this.reverse == otherSimpleSortField.reverse && this.field.equals(otherSimpleSortField.field);
    }

    @Override
    public int hashCode() {
        int result = this.field.hashCode();
        result = 31 * result + (this.reverse ? 1 : 0);
        return result;
    }
}

