/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.sort;

import com.google.common.base.Objects;
import com.google.common.collect.Ordering;
import com.stratio.cassandra.lucene.schema.Schema;
import com.stratio.cassandra.lucene.schema.column.Columns;
import com.stratio.cassandra.lucene.search.sort.SortField;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class Sort
implements Iterable<SortField> {
    private final List<SortField> sortFields;

    public Sort(List<SortField> sortFields) {
        this.sortFields = sortFields;
    }

    @Override
    public Iterator<SortField> iterator() {
        return this.sortFields.iterator();
    }

    public List<SortField> getSortFields() {
        return this.sortFields;
    }

    public List<org.apache.lucene.search.SortField> sortFields(Schema schema) {
        ArrayList<org.apache.lucene.search.SortField> fields = new ArrayList<org.apache.lucene.search.SortField>(this.sortFields.size());
        for (SortField sortField : this.sortFields) {
            fields.add(sortField.sortField(schema));
        }
        return fields;
    }

    public Comparator<Columns> comparator(Schema schema) {
        ArrayList<Comparator<Columns>> comparators = new ArrayList<Comparator<Columns>>();
        for (SortField sortField : this.getSortFields()) {
            comparators.add(sortField.comparator(schema));
        }
        return Ordering.compound(comparators);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("sortFields", this.sortFields).toString();
    }
}

