/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.service;

import com.stratio.cassandra.lucene.schema.Schema;
import com.stratio.cassandra.lucene.schema.column.Column;
import com.stratio.cassandra.lucene.schema.column.ColumnBuilder;
import com.stratio.cassandra.lucene.schema.column.Columns;
import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.MapSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public final class RegularCellsMapper {
    private final CFMetaData metadata;
    private final Schema schema;

    private RegularCellsMapper(CFMetaData metadata, Schema schema) {
        this.metadata = metadata;
        this.schema = schema;
    }

    public static RegularCellsMapper instance(CFMetaData metadata, Schema schema) {
        return new RegularCellsMapper(metadata, schema);
    }

    private Columns process(ColumnBuilder columnBuilder, AbstractType type, ByteBuffer value, boolean hasAnyNotFrozenCollectionAsParent) {
        Columns columns;
        block15: {
            block14: {
                columns = new Columns();
                if (!type.isCollection()) break block14;
                CollectionType collectionType = (CollectionType)type;
                switch (collectionType.kind) {
                    case SET: {
                        AbstractType nameType = collectionType.nameComparator();
                        int colSize = CollectionSerializer.readCollectionSize((ByteBuffer)value, (int)4);
                        for (int j = 0; j < colSize; ++j) {
                            ByteBuffer itemValue = CollectionSerializer.readValue((ByteBuffer)value, (int)4);
                            columns.add(this.process(columnBuilder, nameType, itemValue, hasAnyNotFrozenCollectionAsParent));
                        }
                        break block15;
                    }
                    case LIST: {
                        AbstractType valueType = collectionType.valueComparator();
                        int colSize = CollectionSerializer.readCollectionSize((ByteBuffer)value, (int)4);
                        for (int j = 0; j < colSize; ++j) {
                            ByteBuffer itemValue = CollectionSerializer.readValue((ByteBuffer)value, (int)4);
                            columns.add(this.process(columnBuilder, valueType, itemValue, hasAnyNotFrozenCollectionAsParent));
                        }
                        break block15;
                    }
                    case MAP: {
                        AbstractType keyType = collectionType.nameComparator();
                        AbstractType valueType = collectionType.valueComparator();
                        int colSize = MapSerializer.readCollectionSize((ByteBuffer)value, (int)4);
                        for (int j = 0; j < colSize; ++j) {
                            ByteBuffer mapKey = MapSerializer.readValue((ByteBuffer)value, (int)4);
                            ByteBuffer mapValue = MapSerializer.readValue((ByteBuffer)value, (int)4);
                            String itemName = keyType.compose(mapKey).toString();
                            collectionType.nameComparator();
                            Columns columnsAux = this.process(columnBuilder.clone().mapName(itemName), valueType, mapValue, hasAnyNotFrozenCollectionAsParent);
                            columns.add(columnsAux);
                        }
                        break block15;
                    }
                }
                break block15;
            }
            if (type instanceof UserType) {
                UserType userType = (UserType)type;
                ByteBuffer[] values = userType.split(value);
                for (int i = 0; i < userType.fieldNames().size(); ++i) {
                    String itemName = userType.fieldNameAsString(i);
                    AbstractType itemType = userType.fieldType(i);
                    if (values[i] == null) continue;
                    columns.add(this.process(columnBuilder.clone().udtName(itemName), itemType, values[i], hasAnyNotFrozenCollectionAsParent));
                }
            } else if (type instanceof TupleType) {
                TupleType tupleType = (TupleType)type;
                ByteBuffer[] values = tupleType.split(value);
                Integer i = 0;
                while (i < tupleType.size()) {
                    String itemName = i.toString();
                    AbstractType itemType = tupleType.type(i.intValue());
                    columns.add(this.process(columnBuilder.clone().udtName(itemName), itemType, values[i], hasAnyNotFrozenCollectionAsParent));
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
            } else {
                columns.add(columnBuilder.multiCell(hasAnyNotFrozenCollectionAsParent).decomposedValue(value, type));
            }
        }
        return columns;
    }

    public Columns columns(ColumnFamily columnFamily) {
        Columns columns = new Columns();
        for (Cell cell : columnFamily) {
            ColumnDefinition columnDefinition;
            CellName cellName;
            String name;
            if (!cell.isLive() || (name = (cellName = cell.name()).cql3ColumnName(this.metadata).toString()).length() == 0 || !this.schema.maps(name) || (columnDefinition = this.metadata.getColumnDefinition(cellName)) == null) continue;
            AbstractType valueType = columnDefinition.type;
            ByteBuffer value = ByteBufferUtil.clone((ByteBuffer)cell.value());
            int localDeletionTime = cell.getLocalDeletionTime();
            if (valueType.isCollection() && !valueType.isFrozenCollection()) {
                CollectionType collectionType = (CollectionType)valueType;
                switch (collectionType.kind) {
                    case SET: {
                        AbstractType type = collectionType.nameComparator();
                        value = ByteBufferUtil.clone((ByteBuffer)cell.name().collectionElement());
                        ColumnBuilder columnBuilder = Column.builder(name).localDeletionTime(localDeletionTime);
                        columns.add(this.process(columnBuilder, type, value, true));
                        break;
                    }
                    case LIST: {
                        AbstractType type = collectionType.valueComparator();
                        ColumnBuilder columnBuilder = Column.builder(name).localDeletionTime(localDeletionTime);
                        columns.add(this.process(columnBuilder, type, value, true));
                        break;
                    }
                    case MAP: {
                        AbstractType type = collectionType.valueComparator();
                        ByteBuffer keyValue = cell.name().collectionElement();
                        AbstractType keyType = collectionType.nameComparator();
                        String nameSuffix = keyType.compose(keyValue).toString();
                        ColumnBuilder columnBuilder = Column.builder(name).mapName(nameSuffix).localDeletionTime(localDeletionTime);
                        columns.add(this.process(columnBuilder, type, value, true));
                        break;
                    }
                }
                continue;
            }
            columns.add(this.process(Column.builder(name).localDeletionTime(localDeletionTime), valueType, value, false));
        }
        return columns;
    }
}

