/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.service;

import com.google.common.collect.Ordering;
import com.stratio.cassandra.lucene.IndexConfig;
import com.stratio.cassandra.lucene.key.PartitionMapper;
import com.stratio.cassandra.lucene.key.TokenMapper;
import com.stratio.cassandra.lucene.schema.Schema;
import com.stratio.cassandra.lucene.schema.column.Columns;
import com.stratio.cassandra.lucene.search.Search;
import com.stratio.cassandra.lucene.service.RegularCellsMapper;
import com.stratio.cassandra.lucene.service.RowKey;
import com.stratio.cassandra.lucene.service.RowKeys;
import com.stratio.cassandra.lucene.service.RowMapperSkinny;
import com.stratio.cassandra.lucene.service.RowMapperWide;
import com.stratio.cassandra.lucene.service.SearchResult;
import com.stratio.cassandra.lucene.util.ByteBufferUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SortField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RowMapper {
    protected static final Logger logger = LoggerFactory.getLogger(RowMapper.class);
    final CFMetaData metadata;
    final ColumnDefinition columnDefinition;
    final Schema schema;
    final TokenMapper tokenMapper;
    final PartitionMapper partitionMapper;
    final RegularCellsMapper regularCellsMapper;

    RowMapper(IndexConfig config) {
        this.metadata = config.getMetadata();
        this.columnDefinition = config.getColumnDefinition();
        this.schema = config.getSchema();
        this.tokenMapper = new TokenMapper();
        this.partitionMapper = new PartitionMapper(this.metadata, this.schema);
        this.regularCellsMapper = RegularCellsMapper.instance(this.metadata, this.schema);
    }

    public static RowMapper build(IndexConfig config) {
        return config.isWide() ? new RowMapperWide(config) : new RowMapperSkinny(config);
    }

    public abstract Columns columns(DecoratedKey var1, ColumnFamily var2);

    public final Columns columns(Row row) {
        return this.columns(row.key, row.cf);
    }

    public final DecoratedKey partitionKey(ByteBuffer key) {
        return this.partitionMapper.partitionKey(key);
    }

    public Term term(DecoratedKey partitionKey) {
        return this.partitionMapper.term(partitionKey);
    }

    public abstract Query query(DataRange var1);

    public abstract Query query(RowKey var1);

    public abstract List<SortField> keySortFields();

    public abstract CellName makeCellName(ColumnFamily var1);

    protected abstract Comparator<Row> comparator();

    public Comparator<Row> comparator(Search search) {
        ArrayList<Comparator<Row>> comparators = new ArrayList<Comparator<Row>>();
        if (search.usesSorting()) {
            final Comparator<Columns> comparator = search.getSort().comparator(this.schema);
            comparators.add(new Comparator<Row>(){

                @Override
                public int compare(Row row1, Row row2) {
                    return comparator.compare(RowMapper.this.columns(row1), RowMapper.this.columns(row2));
                }
            });
        }
        if (search.usesRelevance()) {
            comparators.add(new Comparator<Row>(){

                @Override
                public int compare(Row row1, Row row2) {
                    Float score1 = RowMapper.this.score(row1);
                    Float score2 = RowMapper.this.score(row2);
                    return score2.compareTo(score1);
                }
            });
        }
        comparators.add(this.comparator());
        return Ordering.compound(comparators);
    }

    public abstract SearchResult searchResult(Document var1, ScoreDoc var2);

    protected Float score(Row row) {
        ColumnFamily cf = row.cf;
        CellName cellName = this.makeCellName(cf);
        Cell cell = cf.getColumn(cellName);
        String value = (String)UTF8Type.instance.compose(cell.value());
        return Float.valueOf(Float.parseFloat(value));
    }

    public abstract RowKey rowKey(ByteBuffer var1);

    public abstract ByteBuffer byteBuffer(RowKey var1);

    public ByteBuffer byteBuffer(RowKeys rowKeys) {
        ArrayList<byte[]> allBytes = new ArrayList<byte[]>(rowKeys.size());
        int size = 0;
        for (RowKey rowKey : rowKeys) {
            byte[] bytes = ByteBufferUtils.asArray(this.byteBuffer(rowKey));
            allBytes.add(bytes);
            size += bytes.length + 4;
        }
        ByteBuffer bb = ByteBuffer.allocate(size);
        for (byte[] bytes : allBytes) {
            bb.putInt(bytes.length);
            bb.put(bytes);
        }
        bb.rewind();
        return bb;
    }

    public RowKeys rowKeys(ByteBuffer bb) {
        RowKeys rowKeys = new RowKeys();
        bb.rewind();
        while (bb.hasRemaining()) {
            int size = bb.getInt();
            byte[] bytes = new byte[size];
            bb.get(bytes);
            RowKey rowKey = this.rowKey(ByteBuffer.wrap(bytes));
            rowKeys.add(rowKey);
        }
        bb.rewind();
        return rowKeys;
    }

    public abstract RowKey rowKey(Row var1);
}

