/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.service;

import com.stratio.cassandra.lucene.IndexConfig;
import com.stratio.cassandra.lucene.schema.column.Columns;
import com.stratio.cassandra.lucene.service.RowKey;
import com.stratio.cassandra.lucene.service.RowMapper;
import com.stratio.cassandra.lucene.service.SearchResult;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.dht.Token;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;

public class RowMapperSkinny
extends RowMapper {
    RowMapperSkinny(IndexConfig config) {
        super(config);
    }

    @Override
    public Columns columns(DecoratedKey partitionKey, ColumnFamily columnFamily) {
        Columns columns = new Columns();
        columns.add(this.partitionMapper.columns(partitionKey));
        columns.add(this.regularCellsMapper.columns(columnFamily));
        return columns;
    }

    public Document document(DecoratedKey partitionKey, Columns columns) {
        Document document = new Document();
        this.schema.addFields(document, columns);
        if (!document.getFields().isEmpty()) {
            this.tokenMapper.addFields(document, partitionKey);
            this.partitionMapper.addFields(document, partitionKey);
        }
        return document;
    }

    @Override
    public List<SortField> keySortFields() {
        return Arrays.asList(this.tokenMapper.sortField(), this.partitionMapper.sortField());
    }

    @Override
    public final Query query(DataRange dataRange) {
        SliceQueryFilter sliceQueryFilter;
        Composite startName;
        DecoratedKey decoratedKey;
        IDiskAtomFilter filter;
        logger.debug("received query with datarange {}", (Object)dataRange);
        RowPosition startPosition = dataRange.startKey();
        RowPosition stopPosition = dataRange.stopKey();
        Token startToken = startPosition.getToken();
        Token stopToken = stopPosition.getToken();
        boolean includeStart = this.tokenMapper.includeStart(startPosition);
        boolean includeStop = this.tokenMapper.includeStop(stopPosition);
        if (startPosition instanceof DecoratedKey && (filter = dataRange.columnFilter((decoratedKey = (DecoratedKey)startPosition).getKey())) instanceof SliceQueryFilter && (startName = (sliceQueryFilter = (SliceQueryFilter)filter).start()) != null && !startName.isEmpty()) {
            includeStart = false;
        }
        return this.tokenMapper.query(startToken, stopToken, includeStart, includeStop);
    }

    @Override
    public Query query(RowKey rowKey) {
        DecoratedKey partitionKey = rowKey.getPartitionKey();
        Term term = this.term(partitionKey);
        return new TermQuery(term);
    }

    @Override
    public CellName makeCellName(ColumnFamily columnFamily) {
        return this.metadata.comparator.makeCellName(new Object[]{this.columnDefinition.name.bytes});
    }

    @Override
    public Comparator<Row> comparator() {
        return this.tokenMapper.comparator();
    }

    @Override
    public SearchResult searchResult(Document document, ScoreDoc scoreDoc) {
        DecoratedKey partitionKey = this.partitionMapper.partitionKey(document);
        return new SearchResult(partitionKey, null, scoreDoc);
    }

    @Override
    public ByteBuffer byteBuffer(RowKey rowKey) {
        return rowKey.getPartitionKey().getKey();
    }

    @Override
    public RowKey rowKey(ByteBuffer bb) {
        DecoratedKey partitionKey = this.partitionKey(bb);
        return new RowKey(partitionKey, null);
    }

    @Override
    public RowKey rowKey(Row row) {
        DecoratedKey partitionKey = row.key;
        return new RowKey(partitionKey, null);
    }
}

