/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.service;

import com.google.common.collect.Ordering;
import com.stratio.cassandra.lucene.IndexConfig;
import com.stratio.cassandra.lucene.key.KeyMapper;
import com.stratio.cassandra.lucene.schema.column.Columns;
import com.stratio.cassandra.lucene.service.RowKey;
import com.stratio.cassandra.lucene.service.RowMapper;
import com.stratio.cassandra.lucene.service.SearchResult;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;

public class RowMapperWide
extends RowMapper {
    private final KeyMapper keyMapper;

    RowMapperWide(IndexConfig config) {
        super(config);
        this.keyMapper = new KeyMapper(this.metadata);
    }

    @Override
    public Columns columns(DecoratedKey partitionKey, ColumnFamily columnFamily) {
        Columns columns = new Columns();
        columns.add(this.partitionMapper.columns(partitionKey));
        columns.add(this.keyMapper.columns(columnFamily));
        columns.add(this.regularCellsMapper.columns(columnFamily));
        return columns;
    }

    public Document document(DecoratedKey partitionKey, CellName clusteringKey, Columns columns) {
        Document document = new Document();
        this.schema.addFields(document, columns);
        if (!document.getFields().isEmpty()) {
            this.tokenMapper.addFields(document, partitionKey);
            this.partitionMapper.addFields(document, partitionKey);
            this.keyMapper.addFields(document, partitionKey, clusteringKey);
        }
        return document;
    }

    @Override
    public List<SortField> keySortFields() {
        return Arrays.asList(this.tokenMapper.sortField(), this.keyMapper.sortField());
    }

    @Override
    public CellName makeCellName(ColumnFamily columnFamily) {
        CellName clusteringKey = this.clusteringKey(columnFamily);
        return this.keyMapper.makeCellName(clusteringKey, this.columnDefinition);
    }

    @Override
    public Comparator<Row> comparator() {
        return Ordering.compound(Arrays.asList(this.tokenMapper.comparator(), this.keyMapper.rowComparator()));
    }

    private CellName clusteringKey(ColumnFamily columnFamily) {
        return this.keyMapper.clusteringKey(columnFamily);
    }

    public Term term(DecoratedKey partitionKey, CellName clusteringKey) {
        return this.keyMapper.term(partitionKey, clusteringKey);
    }

    @Override
    public Query query(DataRange dataRange) {
        Query query;
        RowPosition startPosition = dataRange.startKey();
        RowPosition stopPosition = dataRange.stopKey();
        Token startToken = startPosition.getToken();
        Token stopToken = stopPosition.getToken();
        SliceQueryFilter sqf = startPosition instanceof DecoratedKey ? (SliceQueryFilter)dataRange.columnFilter(((DecoratedKey)startPosition).getKey()) : (SliceQueryFilter)dataRange.columnFilter(ByteBufferUtil.EMPTY_BYTE_BUFFER);
        boolean isSameToken = startToken.compareTo((Object)stopToken) == 0 && !this.tokenMapper.isMinimum(startToken);
        BooleanClause.Occur occur = isSameToken ? BooleanClause.Occur.FILTER : BooleanClause.Occur.SHOULD;
        boolean includeStart = this.tokenMapper.includeStart(startPosition);
        boolean includeStop = this.tokenMapper.includeStop(stopPosition);
        Composite startName = sqf.start();
        Composite stopName = sqf.finish();
        if (isSameToken && startPosition instanceof DecoratedKey) {
            return this.keyMapper.query((DecoratedKey)startPosition, startName, stopName);
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        if (!startName.isEmpty()) {
            DecoratedKey startKey = (DecoratedKey)startPosition;
            query = this.keyMapper.query(startKey, startName, null);
            builder.add(query, occur);
            includeStart = false;
        }
        if (!stopName.isEmpty()) {
            DecoratedKey stopKey = (DecoratedKey)stopPosition;
            query = this.keyMapper.query(stopKey, null, stopName);
            builder.add(query, occur);
            includeStop = false;
        }
        BooleanQuery query2 = builder.build();
        if (!isSameToken) {
            Query rangeQuery = this.tokenMapper.query(startToken, stopToken, includeStart, includeStop);
            if (rangeQuery != null) {
                builder.add(rangeQuery, BooleanClause.Occur.SHOULD);
                query2 = builder.build();
            }
        } else if (query2.clauses().isEmpty()) {
            return this.tokenMapper.query(startToken);
        }
        return query2.clauses().isEmpty() ? null : query2;
    }

    @Override
    public Query query(RowKey rowKey) {
        DecoratedKey partitionKey = rowKey.getPartitionKey();
        CellName clusteringKey = rowKey.getClusteringKey();
        Term term = this.term(partitionKey, clusteringKey);
        return new TermQuery(term);
    }

    public Query query(DecoratedKey partitionKey, RangeTombstone rangeTombstone) {
        return this.keyMapper.query(partitionKey, (Composite)rangeTombstone.min, (Composite)rangeTombstone.max);
    }

    public ColumnSlice[] columnSlices(List<CellName> clusteringKeys) {
        return this.keyMapper.columnSlices(clusteringKeys);
    }

    public Map<CellName, ColumnFamily> splitRows(ColumnFamily columnFamily) {
        return this.keyMapper.splitRows(columnFamily);
    }

    @Override
    public SearchResult searchResult(Document document, ScoreDoc scoreDoc) {
        DecoratedKey partitionKey = this.partitionMapper.partitionKey(document);
        CellName clusteringKey = this.keyMapper.clusteringKey(document);
        return new SearchResult(partitionKey, clusteringKey, scoreDoc);
    }

    public String hash(DecoratedKey partitionKey, CellName clusteringKey) {
        return this.keyMapper.hash(partitionKey, clusteringKey);
    }

    @Override
    public ByteBuffer byteBuffer(RowKey rowKey) {
        DecoratedKey partitionKey = rowKey.getPartitionKey();
        CellName clusteringKey = rowKey.getClusteringKey();
        return this.keyMapper.byteBuffer(partitionKey, (Composite)clusteringKey);
    }

    @Override
    public RowKey rowKey(ByteBuffer bb) {
        return this.keyMapper.rowKey(bb);
    }

    @Override
    public RowKey rowKey(Row row) {
        DecoratedKey partitionKey = row.key;
        CellName clusteringKey = this.clusteringKey(row.cf);
        return new RowKey(partitionKey, clusteringKey);
    }
}

