/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.service;

import com.stratio.cassandra.lucene.IndexConfig;
import com.stratio.cassandra.lucene.schema.Schema;
import com.stratio.cassandra.lucene.schema.column.Column;
import com.stratio.cassandra.lucene.schema.column.Columns;
import com.stratio.cassandra.lucene.search.Search;
import com.stratio.cassandra.lucene.service.LuceneIndex;
import com.stratio.cassandra.lucene.service.RowKey;
import com.stratio.cassandra.lucene.service.RowMapper;
import com.stratio.cassandra.lucene.service.RowServiceSkinny;
import com.stratio.cassandra.lucene.service.RowServiceWide;
import com.stratio.cassandra.lucene.service.SearchResult;
import com.stratio.cassandra.lucene.util.TaskQueue;
import com.stratio.cassandra.lucene.util.TimeCounter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RowService {
    private static final Logger logger = LoggerFactory.getLogger(RowService.class);
    private static final int MAX_PAGE_SIZE = 10000;
    private static final int MIN_PAGE_SIZE = 100;
    final ColumnFamilyStore baseCfs;
    final CFMetaData metadata;
    final RowMapper mapper;
    final LuceneIndex lucene;
    final List<SortField> keySortFields;
    protected final Schema schema;
    private final TaskQueue indexQueue;

    protected RowService(ColumnFamilyStore cfs, IndexConfig config) throws IOException {
        this.baseCfs = cfs;
        this.metadata = config.getMetadata();
        this.schema = config.getSchema();
        this.mapper = RowMapper.build(config);
        this.keySortFields = this.mapper.keySortFields();
        this.lucene = new LuceneIndex(config, new Sort(this.keySortFields.toArray(new SortField[this.keySortFields.size()])));
        int threads = config.getIndexingThreads();
        this.indexQueue = threads > 0 ? new TaskQueue(threads, config.getIndexingQueuesSize()) : null;
    }

    public static RowService build(ColumnFamilyStore cfs, IndexConfig config) throws IOException {
        return config.isWide() ? new RowServiceWide(cfs, config) : new RowServiceSkinny(cfs, config);
    }

    public final Schema getSchema() {
        return this.schema;
    }

    protected abstract Set<String> fieldsToLoad();

    public abstract void validate(ByteBuffer var1, ColumnFamily var2);

    public void index(final ByteBuffer key, final ColumnFamily columnFamily, final long timestamp) throws IOException {
        if (this.indexQueue == null) {
            this.doIndex(key, columnFamily, timestamp);
        } else {
            this.indexQueue.submitAsynchronous(key, new Runnable(){

                @Override
                public void run() {
                    try {
                        RowService.this.doIndex(key, columnFamily, timestamp);
                    }
                    catch (Exception e) {
                        logger.error("Unrecoverable error during asynchronously indexing", (Throwable)e);
                    }
                }
            });
        }
    }

    protected abstract void doIndex(ByteBuffer var1, ColumnFamily var2, long var3) throws IOException;

    public void delete(final DecoratedKey partitionKey) throws IOException {
        if (this.indexQueue == null) {
            this.doDelete(partitionKey);
        } else {
            this.indexQueue.submitAsynchronous(partitionKey, new Runnable(){

                @Override
                public void run() {
                    try {
                        RowService.this.doDelete(partitionKey);
                    }
                    catch (Exception e) {
                        logger.error("Unrecoverable error during asynchronous deletion", (Throwable)e);
                    }
                }
            });
        }
    }

    protected abstract void doDelete(DecoratedKey var1) throws IOException;

    public final void truncate() throws IOException {
        this.lucene.truncate();
    }

    public final void delete() throws IOException {
        if (this.indexQueue != null) {
            this.indexQueue.shutdown();
        }
        this.lucene.delete();
        this.schema.close();
    }

    public final void commit() throws IOException {
        if (this.indexQueue != null) {
            this.indexQueue.await();
        }
        this.lucene.commit();
    }

    abstract Map<Term, Document> documents(DecoratedKey var1, ColumnFamily var2, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Row> search(Search search, List<IndexExpression> expressions, DataRange dataRange, int limit, long timestamp, RowKey after, boolean distinct) throws IOException {
        TimeCounter afterTime = TimeCounter.create();
        TimeCounter queryTime = TimeCounter.create();
        TimeCounter storeTime = TimeCounter.create();
        int numDocs = 0;
        int numPages = 0;
        int numRows = 0;
        LinkedList<Row> rows = new LinkedList<Row>();
        if (search.refresh()) {
            if (this.indexQueue != null) {
                this.indexQueue.await();
            }
            this.lucene.refresh();
            if (search.isEmpty()) {
                return rows;
            }
        }
        Query query = this.query(search, dataRange);
        Sort sort = this.sort(search);
        int scorePosition = this.scorePosition(search);
        int page = Math.min(limit, 10000);
        SearcherManager searcherManager = this.lucene.getSearcherManager();
        IndexSearcher searcher = (IndexSearcher)searcherManager.acquire();
        sort = sort.rewrite(searcher);
        HashSet<DecoratedKey> partitionKeys = new HashSet<DecoratedKey>();
        try {
            int remainingRows;
            boolean mayBeMoreDocs;
            afterTime.start();
            ScoreDoc last = this.after(searcher, after, query, sort);
            afterTime.stop();
            do {
                queryTime.start();
                Set<String> fields = this.fieldsToLoad();
                Map<Document, ScoreDoc> docs = this.lucene.search(searcher, query, sort, last, page, fields);
                ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>(docs.size());
                int numIterationDocs = 0;
                for (Map.Entry<Document, ScoreDoc> entry : docs.entrySet()) {
                    ScoreDoc scoreDoc;
                    Document document = entry.getKey();
                    last = scoreDoc = entry.getValue();
                    SearchResult searchResult = this.mapper.searchResult(document, scoreDoc);
                    DecoratedKey partitionKey = searchResult.getPartitionKey();
                    if (!(distinct && (partitionKeys.contains(partitionKey) || after != null && after.getPartitionKey().equals((Object)partitionKey)))) {
                        searchResults.add(searchResult);
                        partitionKeys.add(partitionKey);
                    }
                    ++numIterationDocs;
                }
                numDocs += numIterationDocs;
                queryTime.stop();
                storeTime.start();
                for (Row row : this.rows(searchResults, timestamp, scorePosition)) {
                    if (!this.accepted(row, expressions)) continue;
                    rows.add(row);
                    ++numRows;
                }
                storeTime.stop();
                mayBeMoreDocs = numIterationDocs == page;
                remainingRows = limit - numRows;
                page = Math.min(Math.max(100, remainingRows), 10000);
                ++numPages;
            } while (mayBeMoreDocs && remainingRows > 0);
        }
        finally {
            searcherManager.release(searcher);
        }
        Comparator<Row> comparator = this.mapper.comparator(search);
        Collections.sort(rows, comparator);
        logger.debug("Search     : {}", (Object)search);
        logger.debug("After      : {}", (Object)after);
        logger.debug("Query      : {}", (Object)query);
        logger.debug("Sort       : {}", (Object)sort);
        logger.debug("After time : {}", (Object)afterTime);
        logger.debug("Query time : {}", (Object)queryTime);
        logger.debug("Store time : {}", (Object)storeTime);
        logger.debug("Count docs : {}", (Object)numDocs);
        logger.debug("Count rows : {}", (Object)numRows);
        logger.debug("Count page : {}", (Object)numPages);
        return rows;
    }

    public Query query(Search search, DataRange dataRange) {
        Query range = this.mapper.query(dataRange);
        Query query = search.query(this.schema);
        Query filter = search.filter(this.schema);
        if (query == null && filter == null && range == null) {
            return new MatchAllDocsQuery();
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        if (range != null) {
            builder.add(range, BooleanClause.Occur.FILTER);
        }
        if (filter != null) {
            builder.add(filter, BooleanClause.Occur.FILTER);
        }
        if (query != null) {
            builder.add(query, BooleanClause.Occur.MUST);
        }
        return builder.build();
    }

    private Sort sort(Search search) {
        ArrayList<SortField> sortFields = new ArrayList<SortField>();
        if (search.usesSorting()) {
            sortFields.addAll(search.sortFields(this.schema));
        }
        if (search.usesRelevance()) {
            sortFields.add(SortField.FIELD_SCORE);
        }
        sortFields.addAll(this.keySortFields);
        return new Sort(sortFields.toArray(new SortField[sortFields.size()]));
    }

    private int scorePosition(Search search) {
        if (search.usesRelevance()) {
            return search.usesSorting() ? search.sortFields(this.schema).size() : 0;
        }
        return -1;
    }

    private ScoreDoc after(IndexSearcher searcher, RowKey key, Query query, Sort sort) throws IOException {
        if (key == null) {
            return null;
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(this.mapper.query(key), BooleanClause.Occur.FILTER);
        builder.add(query, BooleanClause.Occur.MUST);
        BooleanQuery afterQuery = builder.build();
        Set<String> fields = Collections.emptySet();
        Map<Document, ScoreDoc> results = this.lucene.search(searcher, afterQuery, sort, null, 1, fields);
        return results.isEmpty() ? null : results.values().iterator().next();
    }

    private boolean accepted(Row row, List<IndexExpression> expressions) {
        if (!expressions.isEmpty()) {
            Columns columns = this.mapper.columns(row);
            for (IndexExpression expression : expressions) {
                if (this.accepted(columns, expression)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean accepted(Columns columns, IndexExpression expression) {
        ColumnDefinition def = this.metadata.getColumnDefinition(expression.column);
        String name = def.name.toString();
        ByteBuffer expectedValue = expression.value;
        Operator operator = expression.operator;
        AbstractType validator = def.type;
        for (Column<?> column : columns.getColumnsByCellName(name)) {
            if (!this.accepted(column, validator, operator, expectedValue)) continue;
            return true;
        }
        return false;
    }

    private boolean accepted(Column<?> column, AbstractType<?> validator, Operator operator, ByteBuffer value) {
        if (column == null) {
            return false;
        }
        ByteBuffer actualValue = column.getDecomposedValue();
        if (actualValue == null) {
            return false;
        }
        int comparison = validator.compare((Object)actualValue, (Object)value);
        return this.accepted(operator, comparison);
    }

    private boolean accepted(Operator operator, int comparison) {
        switch (operator) {
            case EQ: {
                return comparison == 0;
            }
            case GTE: {
                return comparison >= 0;
            }
            case GT: {
                return comparison > 0;
            }
            case LTE: {
                return comparison <= 0;
            }
            case LT: {
                return comparison < 0;
            }
        }
        throw new IllegalStateException();
    }

    protected abstract List<Row> rows(List<SearchResult> var1, long var2, int var4);

    protected Row addScoreColumn(Row row, long timestamp, ScoreDoc scoreDoc, int scorePosition) {
        ColumnFamily cf = row.cf;
        CellName cellName = this.mapper.makeCellName(cf);
        FieldDoc fieldDoc = (FieldDoc)scoreDoc;
        Float score = Float.valueOf(Float.parseFloat(fieldDoc.fields[scorePosition].toString()));
        ColumnFamily dcf = ArrayBackedSortedColumns.factory.create(this.baseCfs.metadata);
        ByteBuffer cellValue = UTF8Type.instance.decompose((Object)score.toString());
        dcf.addColumn(cellName, cellValue, timestamp);
        dcf.addAll(row.cf);
        return new Row(row.key, dcf);
    }

    public RowMapper mapper() {
        return this.mapper;
    }
}

