/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.service;

import com.stratio.cassandra.lucene.IndexConfig;
import com.stratio.cassandra.lucene.schema.column.Columns;
import com.stratio.cassandra.lucene.service.RowMapperSkinny;
import com.stratio.cassandra.lucene.service.RowService;
import com.stratio.cassandra.lucene.service.SearchResult;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ScoreDoc;

public class RowServiceSkinny
extends RowService {
    private static final Set<String> FIELDS_TO_LOAD = new HashSet<String>();
    private final RowMapperSkinny mapper;

    public RowServiceSkinny(ColumnFamilyStore cfs, IndexConfig config) throws IOException {
        super(cfs, config);
        this.mapper = (RowMapperSkinny)((RowService)this).mapper;
    }

    @Override
    public Set<String> fieldsToLoad() {
        return FIELDS_TO_LOAD;
    }

    @Override
    public void validate(ByteBuffer key, ColumnFamily columnFamily) {
        DecoratedKey partitionKey = this.mapper.partitionKey(key);
        Columns columns = this.mapper.columns(partitionKey, columnFamily);
        this.schema.validate(columns);
    }

    @Override
    public void doIndex(ByteBuffer key, ColumnFamily columnFamily, long timestamp) throws IOException {
        DecoratedKey partitionKey = this.mapper.partitionKey(key);
        if (columnFamily.iterator().hasNext()) {
            this.lucene.upsert(this.documents(partitionKey, columnFamily, timestamp));
        } else if (columnFamily.deletionInfo() != null) {
            Term term = this.mapper.term(partitionKey);
            this.lucene.delete(term);
        }
    }

    @Override
    public void doDelete(DecoratedKey partitionKey) throws IOException {
        Term term = this.mapper.term(partitionKey);
        this.lucene.delete(term);
    }

    @Override
    public Map<Term, Document> documents(DecoratedKey partitionKey, ColumnFamily columnFamily, long timestamp) {
        Document document;
        Columns columns = this.mapper.columns(partitionKey, columnFamily);
        if (!this.schema.mapsAll(columns)) {
            ColumnFamily completeColumnFamily = this.row(partitionKey, timestamp);
            columns = this.mapper.columns(partitionKey, completeColumnFamily);
        }
        if ((document = this.mapper.document(partitionKey, columns = columns.cleanExpired(timestamp))).getFields().isEmpty()) {
            return Collections.emptyMap();
        }
        Term term = this.mapper.term(partitionKey);
        return Collections.singletonMap(term, document);
    }

    @Override
    protected List<Row> rows(List<SearchResult> searchResults, long timestamp, int scorePosition) {
        ArrayList<Row> rows = new ArrayList<Row>(searchResults.size());
        for (SearchResult searchResult : searchResults) {
            DecoratedKey partitionKey = searchResult.getPartitionKey();
            ColumnFamily columnFamily = this.row(partitionKey, timestamp);
            if (columnFamily == null) continue;
            Row row = new Row(partitionKey, columnFamily);
            if (scorePosition >= 0) {
                ScoreDoc scoreDoc = searchResult.getScoreDoc();
                row = this.addScoreColumn(row, timestamp, scoreDoc, scorePosition);
            }
            rows.add(row);
        }
        return rows;
    }

    private ColumnFamily row(DecoratedKey partitionKey, long timestamp) {
        QueryFilter queryFilter = QueryFilter.getIdentityFilter((DecoratedKey)partitionKey, (String)this.metadata.cfName, (long)timestamp);
        return this.baseCfs.getColumnFamily(queryFilter);
    }

    static {
        FIELDS_TO_LOAD.add("_partition_key");
    }
}

