/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.service;

import com.google.common.collect.Lists;
import com.stratio.cassandra.lucene.IndexConfig;
import com.stratio.cassandra.lucene.schema.column.Columns;
import com.stratio.cassandra.lucene.service.RowMapperWide;
import com.stratio.cassandra.lucene.service.RowService;
import com.stratio.cassandra.lucene.service.SearchResult;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;

public class RowServiceWide
extends RowService {
    private static final Set<String> FIELDS_TO_LOAD = new HashSet<String>();
    private static final int ROWS_PER_SLICE_QUERY = 1000;
    private final RowMapperWide mapper;

    public RowServiceWide(ColumnFamilyStore cfs, IndexConfig config) throws IOException {
        super(cfs, config);
        this.mapper = (RowMapperWide)((RowService)this).mapper;
    }

    @Override
    public Set<String> fieldsToLoad() {
        return FIELDS_TO_LOAD;
    }

    @Override
    public void validate(ByteBuffer key, ColumnFamily columnFamily) {
        DecoratedKey partitionKey = this.mapper.partitionKey(key);
        for (ColumnFamily cf : this.mapper.splitRows(columnFamily).values()) {
            Columns columns = this.mapper.columns(partitionKey, cf);
            this.schema.validate(columns);
        }
    }

    @Override
    public void doIndex(ByteBuffer key, ColumnFamily columnFamily, long timestamp) throws IOException {
        DeletionInfo deletionInfo = columnFamily.deletionInfo();
        DecoratedKey partitionKey = this.mapper.partitionKey(key);
        if (columnFamily.iterator().hasNext()) {
            this.lucene.upsert(this.documents(partitionKey, columnFamily, timestamp));
        } else if (deletionInfo != null) {
            Iterator iterator = deletionInfo.rangeIterator();
            if (iterator.hasNext()) {
                while (iterator.hasNext()) {
                    RangeTombstone rangeTombstone = (RangeTombstone)iterator.next();
                    Query query = this.mapper.query(partitionKey, rangeTombstone);
                    this.lucene.delete(query);
                }
            } else {
                Term term = this.mapper.term(partitionKey);
                this.lucene.delete(term);
            }
        }
    }

    @Override
    public void doDelete(DecoratedKey partitionKey) throws IOException {
        Term term = this.mapper.term(partitionKey);
        this.lucene.delete(term);
    }

    @Override
    public Map<Term, Document> documents(DecoratedKey partitionKey, ColumnFamily columnFamily, long timestamp) {
        Document document;
        Term term;
        Columns columns;
        ColumnFamily rowColumnFamily;
        CellName clusteringKey;
        Map<CellName, ColumnFamily> incomingRows = this.mapper.splitRows(columnFamily);
        HashMap<Term, Document> documents = new HashMap<Term, Document>(incomingRows.size());
        ArrayList<CellName> incompleteRows = new ArrayList<CellName>(incomingRows.size());
        for (Map.Entry<CellName, ColumnFamily> entry : incomingRows.entrySet()) {
            clusteringKey = entry.getKey();
            rowColumnFamily = entry.getValue();
            columns = this.mapper.columns(partitionKey, rowColumnFamily);
            if (this.schema.mapsAll(columns)) {
                columns = columns.cleanExpired(timestamp);
                term = this.mapper.term(partitionKey, clusteringKey);
                document = this.mapper.document(partitionKey, clusteringKey, columns);
                if (document.getFields().isEmpty()) continue;
                documents.put(term, document);
                continue;
            }
            incompleteRows.add(clusteringKey);
        }
        if (!incompleteRows.isEmpty()) {
            for (Map.Entry<CellName, ColumnFamily> entry : this.rows(partitionKey, incompleteRows, timestamp).entrySet()) {
                clusteringKey = entry.getKey();
                rowColumnFamily = entry.getValue();
                columns = this.mapper.columns(partitionKey, rowColumnFamily);
                term = this.mapper.term(partitionKey, clusteringKey);
                document = this.mapper.document(partitionKey, clusteringKey, columns);
                if (document.getFields().isEmpty()) continue;
                documents.put(term, document);
            }
        }
        return documents;
    }

    @Override
    protected List<Row> rows(List<SearchResult> searchResults, long timestamp, int scorePosition) {
        HashMap<String, ScoreDoc> scoresByClusteringKey = new HashMap<String, ScoreDoc>(searchResults.size());
        HashMap<DecoratedKey, ArrayList<CellName>> keys = new HashMap<DecoratedKey, ArrayList<CellName>>();
        for (SearchResult searchResult : searchResults) {
            DecoratedKey partitionKey = searchResult.getPartitionKey();
            CellName clusteringKey = searchResult.getClusteringKey();
            ScoreDoc scoreDoc = searchResult.getScoreDoc();
            String rowHash = this.mapper.hash(partitionKey, clusteringKey);
            scoresByClusteringKey.put(rowHash, scoreDoc);
            ArrayList<CellName> clusteringKeys = (ArrayList<CellName>)keys.get(partitionKey);
            if (clusteringKeys == null) {
                clusteringKeys = new ArrayList<CellName>();
                keys.put(partitionKey, clusteringKeys);
            }
            clusteringKeys.add(clusteringKey);
        }
        ArrayList<Row> rows = new ArrayList<Row>(searchResults.size());
        for (Map.Entry entry : keys.entrySet()) {
            DecoratedKey partitionKey = (DecoratedKey)entry.getKey();
            for (List clusteringKeys : Lists.partition((List)((List)entry.getValue()), (int)1000)) {
                Map<CellName, ColumnFamily> partitionRows = this.rows(partitionKey, clusteringKeys, timestamp);
                for (Map.Entry<CellName, ColumnFamily> entry1 : partitionRows.entrySet()) {
                    CellName clusteringKey = entry1.getKey();
                    ColumnFamily columnFamily = entry1.getValue();
                    Row row = new Row(partitionKey, columnFamily);
                    if (scorePosition >= 0) {
                        String rowHash = this.mapper.hash(partitionKey, clusteringKey);
                        ScoreDoc scoreDoc = (ScoreDoc)scoresByClusteringKey.get(rowHash);
                        row = this.addScoreColumn(row, timestamp, scoreDoc, scorePosition);
                    }
                    rows.add(row);
                }
            }
        }
        return rows;
    }

    private Map<CellName, ColumnFamily> rows(DecoratedKey partitionKey, List<CellName> clusteringKeys, long timestamp) {
        int compositesToGroup;
        SliceQueryFilter dataFilter;
        QueryFilter queryFilter;
        ColumnFamily queryColumnFamily;
        ColumnSlice[] slices = this.mapper.columnSlices(clusteringKeys);
        if (this.baseCfs.metadata.hasStaticColumns()) {
            LinkedList<ColumnSlice> l = new LinkedList<ColumnSlice>(Arrays.asList(slices));
            l.addFirst(this.baseCfs.metadata.comparator.staticPrefix().slice());
            slices = new ColumnSlice[l.size()];
            slices = l.toArray(slices);
        }
        if ((queryColumnFamily = this.baseCfs.getColumnFamily(queryFilter = new QueryFilter(partitionKey, this.baseCfs.name, (IDiskAtomFilter)(dataFilter = new SliceQueryFilter(slices, false, Integer.MAX_VALUE, compositesToGroup = this.baseCfs.metadata.clusteringColumns().size())), timestamp))) == null) {
            return Collections.emptyMap();
        }
        return this.mapper.splitRows(queryColumnFamily);
    }

    static {
        FIELDS_TO_LOAD.add("_partition_key");
        FIELDS_TO_LOAD.add("_primary_key");
    }
}

