/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.service;

import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.composites.CellName;
import org.apache.lucene.search.ScoreDoc;

public class SearchResult {
    private final DecoratedKey partitionKey;
    private final CellName clusteringKey;
    private final ScoreDoc scoreDoc;

    public SearchResult(DecoratedKey partitionKey, CellName clusteringKey, ScoreDoc scoreDoc) {
        this.partitionKey = partitionKey;
        this.clusteringKey = clusteringKey;
        this.scoreDoc = scoreDoc;
    }

    public DecoratedKey getPartitionKey() {
        return this.partitionKey;
    }

    public CellName getClusteringKey() {
        return this.clusteringKey;
    }

    public ScoreDoc getScoreDoc() {
        return this.scoreDoc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchResult that = (SearchResult)o;
        return this.scoreDoc.doc == that.scoreDoc.doc;
    }

    public int hashCode() {
        return this.scoreDoc.doc;
    }
}

