/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.util;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Hex;
import org.apache.lucene.util.BytesRef;

public final class ByteBufferUtils {
    private ByteBufferUtils() {
    }

    public static byte[] asArray(ByteBuffer byteBuffer) {
        ByteBuffer bb = ByteBufferUtil.clone((ByteBuffer)byteBuffer);
        byte[] bytes = new byte[bb.remaining()];
        bb.get(bytes);
        return bytes;
    }

    public static boolean isEmpty(ByteBuffer byteBuffer) {
        return byteBuffer.remaining() == 0;
    }

    public static ByteBuffer[] split(ByteBuffer byteBuffer, AbstractType<?> type) {
        if (type instanceof CompositeType) {
            return ((CompositeType)type).split(byteBuffer);
        }
        return new ByteBuffer[]{byteBuffer};
    }

    public static String toString(ByteBuffer byteBuffer, AbstractType<?> type) {
        if (type instanceof CompositeType) {
            CompositeType composite = (CompositeType)type;
            List types = composite.types;
            ByteBuffer[] components = composite.split(byteBuffer);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < components.length; ++i) {
                AbstractType componentType = (AbstractType)types.get(i);
                ByteBuffer component = components[i];
                sb.append(componentType.compose(component));
                if (i >= types.size() - 1) continue;
                sb.append(':');
            }
            return sb.toString();
        }
        return type.compose(byteBuffer).toString();
    }

    public static String toHex(ByteBuffer byteBuffer) {
        return ByteBufferUtil.bytesToHex((ByteBuffer)byteBuffer);
    }

    public static String toHex(BytesRef bytesRef) {
        return ByteBufferUtil.bytesToHex((ByteBuffer)ByteBufferUtils.byteBuffer(bytesRef));
    }

    public static String toHex(byte[] bytes) {
        return Hex.bytesToHex((byte[])bytes);
    }

    public static String toHex(byte b) {
        return Hex.bytesToHex((byte[])new byte[]{b});
    }

    public static BytesRef bytesRef(ByteBuffer bb) {
        byte[] bytes = ByteBufferUtils.asArray(bb);
        return new BytesRef(bytes);
    }

    public static ByteBuffer byteBuffer(BytesRef bytesRef) {
        byte[] bytes = bytesRef.bytes;
        return ByteBuffer.wrap(bytes, bytesRef.offset, bytesRef.offset + bytesRef.length);
    }
}

