/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.util;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.column.Column;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.utils.UUIDGen;

public class DateParser {
    static final Long DAYS_TO_MILLIS = 86400000L;
    public static final String DEFAULT_PATTERN = "yyyy/MM/dd HH:mm:ss.SSS Z";
    public static final String TIMESTAMP_PATTERN_FIELD = "timestamp";
    private final String pattern;
    private final ThreadLocal<DateFormat> concurrentDateFormat;

    public DateParser(String pattern) {
        String string = this.pattern = pattern == null ? DEFAULT_PATTERN : pattern;
        if (!this.pattern.equals(TIMESTAMP_PATTERN_FIELD)) {
            new SimpleDateFormat(this.pattern);
            this.concurrentDateFormat = new ThreadLocal<DateFormat>(){

                @Override
                protected DateFormat initialValue() {
                    return new SimpleDateFormat(DateParser.this.pattern);
                }
            };
            this.concurrentDateFormat.get().setLenient(false);
        } else {
            this.concurrentDateFormat = null;
        }
    }

    public <K> Date parse(Column<K> column) {
        if (column.getType() instanceof SimpleDateType) {
            long timestamp = SimpleDateType.instance.toTimeInMillis(column.getDecomposedValue());
            if (this.concurrentDateFormat == null) {
                return new Date(timestamp);
            }
            int offset = this.concurrentDateFormat.get().getTimeZone().getOffset(timestamp);
            return new Date(timestamp - (long)offset);
        }
        return this.parse(column.getComposedValue());
    }

    public Date parse(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Integer) {
            if ((Integer)value < 0) {
                throw new IndexException("Required positive Integer for dates but found '%s'", value);
            }
            return new Date(DAYS_TO_MILLIS * (long)((Integer)value).intValue());
        }
        if (value instanceof Long) {
            if ((Long)value < 0L) {
                throw new IndexException("Required positive Long for dates but found '%s'", value);
            }
            return new Date((Long)value);
        }
        if (value instanceof UUID) {
            try {
                return new Date(UUIDGen.unixTimestamp((UUID)((UUID)value)));
            }
            catch (UnsupportedOperationException e) {
                throw new IndexException("Required a version 1 UUID but found '%s'", value);
            }
        }
        if (this.pattern.equals(TIMESTAMP_PATTERN_FIELD)) {
            return this.parseAsTimestamp(value);
        }
        return this.parseAsFormattedDate(value);
    }

    private Date parseAsTimestamp(Object value) {
        Long valueLong;
        if (value instanceof Number) {
            valueLong = ((Number)value).longValue();
        } else {
            try {
                valueLong = Long.parseLong(value.toString());
            }
            catch (NumberFormatException e) {
                valueLong = null;
            }
        }
        if (valueLong != null) {
            return new Date(valueLong);
        }
        throw new IndexException("Valid timestamp required but found '%s'", value);
    }

    private Date parseAsFormattedDate(Object value) {
        try {
            return this.concurrentDateFormat.get().parse(value.toString());
        }
        catch (ParseException e) {
            throw new IndexException("Required date with pattern '%s' but found '%s'", this.pattern, value);
        }
    }

    public String toString() {
        return this.pattern;
    }

    public String toString(Date date) {
        if (this.pattern.equals(TIMESTAMP_PATTERN_FIELD)) {
            return Long.valueOf(date.getTime()).toString();
        }
        return this.concurrentDateFormat.get().format(date);
    }
}

