/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.util;

import com.spatial4j.core.context.SpatialContext;
import com.stratio.cassandra.lucene.IndexException;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;

public class GeospatialUtils {
    public static final SpatialContext CONTEXT = SpatialContext.GEO;
    public static final int DEFAULT_GEOHASH_MAX_LEVELS = 11;

    public static int validateGeohashMaxLevels(Integer maxLevels) {
        if (maxLevels == null) {
            return 11;
        }
        if (maxLevels < 1 || maxLevels > GeohashPrefixTree.getMaxLevelsPossible()) {
            throw new IndexException("max_levels must be in range [1, %s], but found %s", GeohashPrefixTree.getMaxLevelsPossible(), maxLevels);
        }
        return maxLevels;
    }
}

