/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.util;

import com.spatial4j.core.context.jts.JtsSpatialContext;
import com.spatial4j.core.shape.jts.JtsGeometry;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.util.GeospatialUtils;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import org.apache.commons.lang3.StringUtils;

public class GeospatialUtilsJTS
extends GeospatialUtils {
    public static final JtsSpatialContext CONTEXT = JtsSpatialContext.GEO;

    public static JtsGeometry geometry(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IndexException("Shape shouldn't be blank", new Object[0]);
        }
        try {
            GeometryFactory geometryFactory = CONTEXT.getGeometryFactory();
            WKTReader reader = new WKTReader(geometryFactory);
            Geometry geometry = reader.read(string);
            if (!geometry.isValid()) {
                geometry = geometry.buffer(0.0);
            }
            return CONTEXT.makeShape(geometry);
        }
        catch (ParseException | IllegalArgumentException e) {
            throw new IndexException(e, "Shape '%s' is not parseable", string);
        }
    }
}

