/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.util;

import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public final class JsonSerializer {
    private static final JsonSerializer INSTANCE = new JsonSerializer();
    private final ObjectMapper jsonMapper = new ObjectMapper();

    private JsonSerializer() {
        this.jsonMapper.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, false);
        this.jsonMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        this.jsonMapper.configure(SerializationConfig.Feature.AUTO_DETECT_IS_GETTERS, false);
        this.jsonMapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.jsonMapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    }

    public static String toString(Object value) throws IOException {
        return JsonSerializer.INSTANCE.jsonMapper.writeValueAsString(value);
    }

    public static <T> T fromString(String value, Class<T> valueType) throws IOException {
        return JsonSerializer.INSTANCE.jsonMapper.readValue(value, valueType);
    }
}

