/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.util;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class NotifyingBlockingThreadPoolExecutor
extends ThreadPoolExecutor {
    private AtomicInteger tasksInProcess = new AtomicInteger();
    private Synchronizer synchronizer = new Synchronizer();

    public NotifyingBlockingThreadPoolExecutor(int poolSize, int queueSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, long maxBlockingTime, TimeUnit maxBlockingTimeUnit, Callable<Boolean> blockingTimeCallback) {
        super(poolSize, poolSize, keepAliveTime, keepAliveTimeUnit, new ArrayBlockingQueue<Runnable>(Math.max(poolSize, queueSize), true), new BlockThenRunPolicy(maxBlockingTime, maxBlockingTimeUnit, blockingTimeCallback));
        super.allowCoreThreadTimeOut(true);
    }

    public NotifyingBlockingThreadPoolExecutor(int poolSize, int queueSize, long keepAliveTime, TimeUnit unit) {
        super(poolSize, poolSize, keepAliveTime, unit, new ArrayBlockingQueue<Runnable>(Math.max(poolSize, queueSize), true), new BlockThenRunPolicy());
        super.allowCoreThreadTimeOut(true);
    }

    @Override
    public void execute(Runnable task) {
        this.tasksInProcess.incrementAndGet();
        try {
            super.execute(task);
        }
        catch (Error | RuntimeException e) {
            this.tasksInProcess.decrementAndGet();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        NotifyingBlockingThreadPoolExecutor notifyingBlockingThreadPoolExecutor = this;
        synchronized (notifyingBlockingThreadPoolExecutor) {
            this.tasksInProcess.decrementAndGet();
            if (this.tasksInProcess.intValue() == 0) {
                this.synchronizer.signalAll();
            }
        }
    }

    @Override
    public void setCorePoolSize(int corePoolSize) {
        super.setCorePoolSize(corePoolSize);
        super.setMaximumPoolSize(corePoolSize);
    }

    @Override
    public void setMaximumPoolSize(int maximumPoolSize) {
        throw new UnsupportedOperationException("setMaximumPoolSize is not supported.");
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        throw new UnsupportedOperationException("setRejectedExecutionHandler is not allowed on this class.");
    }

    public void await() throws InterruptedException {
        this.synchronizer.await();
    }

    public boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.synchronizer.await(timeout, timeUnit);
    }

    private static class BlockThenRunPolicy
    implements RejectedExecutionHandler {
        private long maxBlockingTime;
        private TimeUnit maxBlockingTimeUnit;
        private Callable<Boolean> blockingTimeCallback;

        BlockThenRunPolicy(long maxBlockingTime, TimeUnit maxBlockingTimeUnit, Callable<Boolean> blockingTimeCallback) {
            this.maxBlockingTime = maxBlockingTime;
            this.maxBlockingTimeUnit = maxBlockingTimeUnit;
            this.blockingTimeCallback = blockingTimeCallback;
        }

        public BlockThenRunPolicy() {
        }

        @Override
        public void rejectedExecution(Runnable task, ThreadPoolExecutor executor) {
            BlockingQueue<Runnable> workQueue = executor.getQueue();
            boolean taskSent = false;
            while (!taskSent) {
                if (executor.isShutdown()) {
                    throw new RejectedExecutionException("ThreadPoolExecutor has shutdown while attempting to offer a new task.");
                }
                try {
                    if (this.blockingTimeCallback != null) {
                        Boolean result;
                        if (workQueue.offer(task, this.maxBlockingTime, this.maxBlockingTimeUnit)) {
                            taskSent = true;
                            continue;
                        }
                        try {
                            result = this.blockingTimeCallback.call();
                        }
                        catch (Exception e) {
                            throw new RejectedExecutionException(e);
                        }
                        if (result.booleanValue()) continue;
                        throw new RejectedExecutionException("User decided to stop waiting for task insertion");
                    }
                    workQueue.put(task);
                    taskSent = true;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class Synchronizer {
        private final Lock lock = new ReentrantLock();
        private final Condition done = this.lock.newCondition();
        private boolean isDone = false;

        private Synchronizer() {
        }

        private void signalAll() {
            this.lock.lock();
            try {
                this.isDone = true;
                this.done.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        public void await() throws InterruptedException {
            this.lock.lock();
            try {
                while (!this.isDone) {
                    this.done.await();
                }
            }
            finally {
                this.isDone = false;
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
            boolean localIsDone;
            boolean awaitResult = false;
            this.lock.lock();
            try {
                awaitResult = this.done.await(timeout, timeUnit);
            }
            finally {
                localIsDone = this.isDone;
                this.isDone = false;
                this.lock.unlock();
            }
            return awaitResult && localIsDone;
        }
    }
}

