/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.util;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.util.NotifyingBlockingThreadPoolExecutor;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskQueue {
    private static final Logger logger = LoggerFactory.getLogger(TaskQueue.class);
    private final NotifyingBlockingThreadPoolExecutor[] pools;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public TaskQueue(int numThreads, int queuesSize) {
        this.pools = new NotifyingBlockingThreadPoolExecutor[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            this.pools[i] = new NotifyingBlockingThreadPoolExecutor(1, queuesSize, Long.MAX_VALUE, TimeUnit.DAYS, 0L, TimeUnit.NANOSECONDS, null);
            this.pools[i].submit(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Task queue starts");
                }
            });
        }
    }

    public Future<?> submitAsynchronous(Object id, Runnable task) {
        this.lock.readLock().lock();
        try {
            int i = Math.abs(id.hashCode() % this.pools.length);
            Future<?> future = this.pools[i].submit(task);
            return future;
        }
        catch (Exception e) {
            logger.error("Task queue submission failed", (Throwable)e);
            throw new IndexException(e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void submitSynchronous(Runnable task) {
        this.lock.writeLock().lock();
        try {
            this.await();
            task.run();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void await() {
        this.lock.writeLock().lock();
        try {
            Future[] futures = new Future[this.pools.length];
            for (int i = 0; i < this.pools.length; ++i) {
                Future<?> future;
                futures[i] = future = this.pools[i].submit(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            }
            for (Future future : futures) {
                future.get();
            }
        }
        catch (InterruptedException e) {
            logger.error("Task queue await interrupted", (Throwable)e);
            throw new IndexException(e);
        }
        catch (ExecutionException e) {
            logger.error("Task queue await failed", (Throwable)e);
            throw new IndexException(e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void shutdown() {
        this.lock.writeLock().lock();
        try {
            for (int i = 0; i < this.pools.length; ++i) {
                this.pools[i].shutdown();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

