/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.util;

public final class TimeCounter {
    private long startTimeMillis;
    private long stopTimeMillis;
    private State state = State.UNSTARTED;

    public static TimeCounter create() {
        return new TimeCounter();
    }

    private TimeCounter() {
    }

    public TimeCounter start() {
        switch (this.state) {
            case UNSTARTED: {
                this.startTimeMillis = System.currentTimeMillis();
                break;
            }
            case RUNNING: {
                throw new IllegalStateException("Already started. ");
            }
            case STOPPED: {
                this.startTimeMillis += System.currentTimeMillis() - this.stopTimeMillis;
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized state " + (Object)((Object)this.state));
            }
        }
        this.state = State.RUNNING;
        return this;
    }

    public TimeCounter stop() {
        switch (this.state) {
            case UNSTARTED: {
                throw new IllegalStateException("Not started. ");
            }
            case STOPPED: {
                throw new IllegalStateException("Already stopped. ");
            }
            case RUNNING: {
                this.stopTimeMillis = System.currentTimeMillis();
            }
        }
        this.state = State.STOPPED;
        return this;
    }

    public String toString() {
        return String.valueOf(this.stopTimeMillis - this.startTimeMillis) + " ms";
    }

    public long getTime() {
        return this.stopTimeMillis - this.startTimeMillis;
    }

    private static enum State {
        UNSTARTED,
        RUNNING,
        STOPPED;

    }
}

