/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.util;

import com.google.common.base.Objects;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.util.FilteringTokenFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenLengthAnalyzer
extends AnalyzerWrapper {
    private static final Logger logger = LoggerFactory.getLogger(TokenLengthAnalyzer.class);
    private final Analyzer analyzer;

    public TokenLengthAnalyzer(Analyzer analyzer) {
        super(analyzer.getReuseStrategy());
        this.analyzer = analyzer;
    }

    @Override
    protected Analyzer getWrappedAnalyzer(String fieldName) {
        return this.analyzer;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    @Override
    protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
        TokenLengthFilter tokenFilter = new TokenLengthFilter(components.getTokenStream(), fieldName);
        return new Analyzer.TokenStreamComponents(components.getTokenizer(), tokenFilter);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("analyzer", (Object)this.analyzer).toString();
    }

    static final class TokenLengthFilter
    extends FilteringTokenFilter {
        private final CharTermAttribute tm = this.addAttribute(CharTermAttribute.class);
        private final String fieldName;

        private TokenLengthFilter(TokenStream tokenStream, String fieldName) {
            super(tokenStream);
            this.fieldName = fieldName;
        }

        @Override
        protected boolean accept() throws IOException {
            int maxSize = 32766;
            int size = this.tm.length();
            if (size > maxSize) {
                logger.error("Discarding immense term in field='{}', Lucene only allows terms with at most {} bytes in length; got {}", new Object[]{this.fieldName, maxSize, size});
                return false;
            }
            return true;
        }
    }
}

