/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.bkdtree3d;

import java.io.IOException;
import org.apache.lucene.bkdtree3d.BKD3DTreeReader;
import org.apache.lucene.bkdtree3d.Geo3DBinaryDocValues;
import org.apache.lucene.bkdtree3d.Geo3DDocValuesFormat;
import org.apache.lucene.geo3d.GeoArea;
import org.apache.lucene.geo3d.GeoAreaFactory;
import org.apache.lucene.geo3d.GeoShape;
import org.apache.lucene.geo3d.PlanetModel;
import org.apache.lucene.geo3d.XYZBounds;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.ToStringUtils;

@Deprecated
public class PointInGeo3DShapeQuery
extends Query {
    final String field;
    final PlanetModel planetModel;
    final GeoShape shape;

    public PointInGeo3DShapeQuery(PlanetModel planetModel, String field, GeoShape shape) {
        this.field = field;
        this.planetModel = planetModel;
        this.shape = shape;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                LeafReader reader = context.reader();
                BinaryDocValues bdv = reader.getBinaryDocValues(PointInGeo3DShapeQuery.this.field);
                if (bdv == null) {
                    return null;
                }
                if (!(bdv instanceof Geo3DBinaryDocValues)) {
                    throw new IllegalStateException("field \"" + PointInGeo3DShapeQuery.this.field + "\" was not indexed with Geo3DBinaryDocValuesFormat: got: " + bdv);
                }
                final Geo3DBinaryDocValues treeDV = (Geo3DBinaryDocValues)bdv;
                BKD3DTreeReader tree = treeDV.getBKD3DTreeReader();
                XYZBounds bounds = new XYZBounds();
                PointInGeo3DShapeQuery.this.shape.getBounds(bounds);
                double planetMax = PointInGeo3DShapeQuery.this.planetModel.getMaximumMagnitude();
                if (planetMax != treeDV.planetMax) {
                    throw new IllegalStateException(PointInGeo3DShapeQuery.this.planetModel + " is not the same one used during indexing: planetMax=" + planetMax + " vs indexing planetMax=" + treeDV.planetMax);
                }
                DocIdSet result = tree.intersect(Geo3DDocValuesFormat.encodeValueLenient(planetMax, bounds.getMinimumX()), Geo3DDocValuesFormat.encodeValueLenient(planetMax, bounds.getMaximumX()), Geo3DDocValuesFormat.encodeValueLenient(planetMax, bounds.getMinimumY()), Geo3DDocValuesFormat.encodeValueLenient(planetMax, bounds.getMaximumY()), Geo3DDocValuesFormat.encodeValueLenient(planetMax, bounds.getMinimumZ()), Geo3DDocValuesFormat.encodeValueLenient(planetMax, bounds.getMaximumZ()), new BKD3DTreeReader.ValueFilter(){

                    @Override
                    public boolean accept(int docID) {
                        BytesRef bytes = treeDV.get(docID);
                        if (bytes == null) {
                            return false;
                        }
                        assert (bytes.length == 12);
                        double x = Geo3DDocValuesFormat.decodeValueCenter(treeDV.planetMax, Geo3DDocValuesFormat.readInt(bytes.bytes, bytes.offset));
                        double y = Geo3DDocValuesFormat.decodeValueCenter(treeDV.planetMax, Geo3DDocValuesFormat.readInt(bytes.bytes, bytes.offset + 4));
                        double z = Geo3DDocValuesFormat.decodeValueCenter(treeDV.planetMax, Geo3DDocValuesFormat.readInt(bytes.bytes, bytes.offset + 8));
                        return PointInGeo3DShapeQuery.this.shape.isWithin(x, y, z);
                    }

                    @Override
                    public BKD3DTreeReader.Relation compare(int cellXMinEnc, int cellXMaxEnc, int cellYMinEnc, int cellYMaxEnc, int cellZMinEnc, int cellZMaxEnc) {
                        assert (cellXMinEnc <= cellXMaxEnc);
                        assert (cellYMinEnc <= cellYMaxEnc);
                        assert (cellZMinEnc <= cellZMaxEnc);
                        double cellXMin = Geo3DDocValuesFormat.decodeValueMin(treeDV.planetMax, cellXMinEnc);
                        double cellXMax = Geo3DDocValuesFormat.decodeValueMax(treeDV.planetMax, cellXMaxEnc);
                        double cellYMin = Geo3DDocValuesFormat.decodeValueMin(treeDV.planetMax, cellYMinEnc);
                        double cellYMax = Geo3DDocValuesFormat.decodeValueMax(treeDV.planetMax, cellYMaxEnc);
                        double cellZMin = Geo3DDocValuesFormat.decodeValueMin(treeDV.planetMax, cellZMinEnc);
                        double cellZMax = Geo3DDocValuesFormat.decodeValueMax(treeDV.planetMax, cellZMaxEnc);
                        GeoArea xyzSolid = GeoAreaFactory.makeGeoArea(PointInGeo3DShapeQuery.this.planetModel, cellXMin, cellXMax, cellYMin, cellYMax, cellZMin, cellZMax);
                        switch (xyzSolid.getRelationship(PointInGeo3DShapeQuery.this.shape)) {
                            case 0: {
                                return BKD3DTreeReader.Relation.CELL_INSIDE_SHAPE;
                            }
                            case 2: {
                                return BKD3DTreeReader.Relation.SHAPE_CROSSES_CELL;
                            }
                            case 1: {
                                return BKD3DTreeReader.Relation.SHAPE_INSIDE_CELL;
                            }
                            case 3: {
                                return BKD3DTreeReader.Relation.SHAPE_OUTSIDE_CELL;
                            }
                        }
                        assert (false);
                        return BKD3DTreeReader.Relation.SHAPE_CROSSES_CELL;
                    }
                });
                DocIdSetIterator disi = result.iterator();
                return new ConstantScoreScorer((Weight)this, this.score(), disi);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PointInGeo3DShapeQuery that = (PointInGeo3DShapeQuery)o;
        return this.planetModel.equals(that.planetModel) && this.shape.equals(that.shape);
    }

    @Override
    public final int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.planetModel.hashCode();
        result = 31 * result + this.shape.hashCode();
        return result;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("PlanetModel: ");
        sb.append(this.planetModel);
        sb.append(" Shape: ");
        sb.append(this.shape);
        sb.append(ToStringUtils.boost(this.getBoost()));
        return sb.toString();
    }
}

