/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.spatial.prefix.AbstractVisitingPrefixTreeQuery;
import org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.FixedBitSet;

public class IntersectsPrefixTreeQuery
extends AbstractVisitingPrefixTreeQuery {
    public IntersectsPrefixTreeQuery(Shape queryShape, String fieldName, SpatialPrefixTree grid, int detailLevel, int prefixGridScanLevel) {
        super(queryShape, fieldName, grid, detailLevel, prefixGridScanLevel);
    }

    @Override
    protected DocIdSet getDocIdSet(LeafReaderContext context) throws IOException {
        return new AbstractVisitingPrefixTreeQuery.VisitorTemplate(context){
            private FixedBitSet results;

            @Override
            protected void start() {
                this.results = new FixedBitSet(this.maxDoc);
            }

            @Override
            protected DocIdSet finish() {
                return new BitDocIdSet(this.results);
            }

            @Override
            protected boolean visitPrefix(Cell cell) throws IOException {
                if (cell.getShapeRel() == SpatialRelation.WITHIN || cell.getLevel() == IntersectsPrefixTreeQuery.this.detailLevel) {
                    this.collectDocs(this.results);
                    return false;
                }
                return true;
            }

            @Override
            protected void visitLeaf(Cell cell) throws IOException {
                this.collectDocs(this.results);
            }
        }.getDocIdSet();
    }

    @Override
    public String toString(String field) {
        return this.getClass().getSimpleName() + "(" + "fieldName=" + this.fieldName + "," + "queryShape=" + this.queryShape + "," + "detailLevel=" + this.detailLevel + "," + "prefixGridScanLevel=" + this.prefixGridScanLevel + ")";
    }
}

