/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.io;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.SpatialContextFactory;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.io.ShapeReader;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class PolyshapeReader
implements ShapeReader {
    final SpatialContext ctx;

    public PolyshapeReader(SpatialContext ctx, SpatialContextFactory factory) {
        this.ctx = ctx;
    }

    @Override
    public String getFormatName() {
        return "POLY";
    }

    protected Shape makeCollection(List<? extends Shape> shapes) {
        return this.ctx.makeCollection(shapes);
    }

    @Override
    public Shape read(Object value) throws IOException, ParseException, InvalidShapeException {
        return this.read(new StringReader(value.toString().trim()));
    }

    @Override
    public Shape readIfSupported(Object value) throws InvalidShapeException {
        String v = value.toString().trim();
        char first = v.charAt(0);
        if (first >= '0' && first <= '9') {
            try {
                return this.read(new StringReader(v));
            }
            catch (ParseException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public final Shape read(Reader r) throws ParseException, IOException {
        XReader reader = new XReader(r);
        Double arg = null;
        Shape lastShape = null;
        ArrayList<Shape> shapes = null;
        block8: while (!reader.isDone()) {
            char event = reader.readKey();
            if (event < '0' || event > '9') {
                if (event == ' ') continue;
                throw new ParseException("expecting a shape key.  not '" + event + "'", -1);
            }
            if (lastShape != null) {
                if (shapes == null) {
                    shapes = new ArrayList<Shape>();
                }
                shapes.add(lastShape);
            }
            arg = null;
            if (reader.peek() == 40) {
                reader.readKey();
                arg = reader.readDouble();
                if (reader.readKey() != ')') {
                    throw new ParseException("expecting an argument end", -1);
                }
            }
            if (reader.isEvent()) {
                throw new ParseException("Invalid input. Event should be followed by data", -1);
            }
            switch (event) {
                case '0': {
                    lastShape = this.ctx.makePoint(reader.readLat(), reader.readLng());
                    continue block8;
                }
                case '1': {
                    if (arg != null) {
                        lastShape = this.ctx.makeBufferedLineString(reader.readPoints(this.ctx), arg);
                        continue block8;
                    }
                    lastShape = this.ctx.makeLineString(reader.readPoints(this.ctx));
                    continue block8;
                }
                case '5': {
                    Point lowerLeft = this.ctx.makePoint(reader.readLat(), reader.readLng());
                    Point upperRight = this.ctx.makePoint(reader.readLat(), reader.readLng());
                    lastShape = this.ctx.makeRectangle(lowerLeft, upperRight);
                    continue block8;
                }
                case '3': {
                    List<Point> points = reader.readPoints(this.ctx);
                    lastShape = this.makeCollection(points);
                    continue block8;
                }
                case '4': {
                    if (arg == null) {
                        throw new IllegalArgumentException("the input should have a radius argument");
                    }
                    lastShape = this.ctx.makeCircle(reader.readLat(), reader.readLng(), arg);
                    continue block8;
                }
                case '2': {
                    lastShape = this.readPolygon(reader);
                    continue block8;
                }
            }
            throw new ParseException("unhandled key: " + event, -1);
        }
        if (shapes != null) {
            if (lastShape != null) {
                shapes.add(lastShape);
            }
            return this.makeCollection((List<? extends Shape>)shapes);
        }
        return lastShape;
    }

    protected Shape readPolygon(XReader reader) throws IOException {
        throw new IllegalArgumentException("This reader does not support polygons");
    }

    public static class XReader {
        int lat = 0;
        int lng = 0;
        int head = -1;
        final Reader input;

        public XReader(Reader input) throws IOException {
            this.input = input;
            this.head = input.read();
        }

        public List<Point> readPoints(SpatialContext ctx) throws IOException {
            ArrayList<Point> points = new ArrayList<Point>();
            while (this.isData()) {
                points.add(ctx.makePoint(this.readLat(), this.readLng()));
            }
            return points;
        }

        public List<double[]> readPoints() throws IOException {
            ArrayList<double[]> points = new ArrayList<double[]>();
            while (this.isData()) {
                points.add(new double[]{this.readLat(), this.readLng()});
            }
            return points;
        }

        public double readLat() throws IOException {
            this.lat += this.readInt();
            return (double)this.lat * 1.0E-5;
        }

        public double readLng() throws IOException {
            this.lng += this.readInt();
            return (double)this.lng * 1.0E-5;
        }

        public double readDouble() throws IOException {
            return (double)this.readInt() * 1.0E-5;
        }

        public int peek() {
            return this.head;
        }

        public char readKey() throws IOException {
            this.lng = 0;
            this.lat = 0;
            char key = (char)this.head;
            this.head = this.input.read();
            return key;
        }

        public boolean isData() {
            return this.head >= 63;
        }

        public boolean isDone() {
            return this.head < 0;
        }

        public boolean isEvent() {
            return this.head > 0 && this.head < 63;
        }

        int readInt() throws IOException {
            int b;
            int result2 = 1;
            int shift = 0;
            do {
                b = this.head - 63 - 1;
                result2 += b << shift;
                shift += 5;
                this.head = this.input.read();
            } while (b >= 31);
            return (result2 & 1) != 0 ? ~(result2 >> 1) : result2 >> 1;
        }
    }
}

