/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.io;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.SpatialContextFactory;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.io.ShapeReader;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WKTReader
implements ShapeReader {
    protected final SpatialContext ctx;

    public WKTReader(SpatialContext ctx, SpatialContextFactory factory) {
        this.ctx = ctx;
    }

    public Shape parse(String wktString) throws ParseException, InvalidShapeException {
        Shape shape = this.parseIfSupported(wktString);
        if (shape != null) {
            return shape;
        }
        String shortenedString = wktString.length() <= 128 ? wktString : wktString.substring(0, 125) + "...";
        throw new ParseException("Unknown Shape definition [" + shortenedString + "]", 0);
    }

    public Shape parseIfSupported(String wktString) throws ParseException, InvalidShapeException {
        State state = this.newState(wktString);
        state.nextIfWhitespace();
        if (state.eof()) {
            return null;
        }
        if (!Character.isLetter(state.rawString.charAt(state.offset))) {
            return null;
        }
        String shapeType = state.nextWord();
        Shape result2 = null;
        try {
            result2 = this.parseShapeByType(state, shapeType);
        }
        catch (ParseException e) {
            throw e;
        }
        catch (InvalidShapeException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidShapeException(e.getMessage(), e);
        }
        catch (Exception e) {
            ParseException pe = new ParseException(e.toString(), state.offset);
            pe.initCause(e);
            throw pe;
        }
        if (result2 != null && !state.eof()) {
            throw new ParseException("end of shape expected", state.offset);
        }
        return result2;
    }

    protected State newState(String wktString) {
        return new State(wktString);
    }

    protected Shape parseShapeByType(State state, String shapeType) throws ParseException {
        assert (Character.isLetter(shapeType.charAt(0))) : "Shape must start with letter: " + shapeType;
        if (shapeType.equalsIgnoreCase("POINT")) {
            return this.parsePointShape(state);
        }
        if (shapeType.equalsIgnoreCase("MULTIPOINT")) {
            return this.parseMultiPointShape(state);
        }
        if (shapeType.equalsIgnoreCase("ENVELOPE")) {
            return this.parseEnvelopeShape(state);
        }
        if (shapeType.equalsIgnoreCase("GEOMETRYCOLLECTION")) {
            return this.parseGeometryCollectionShape(state);
        }
        if (shapeType.equalsIgnoreCase("LINESTRING")) {
            return this.parseLineStringShape(state);
        }
        if (shapeType.equalsIgnoreCase("MULTILINESTRING")) {
            return this.parseMultiLineStringShape(state);
        }
        if (shapeType.equalsIgnoreCase("BUFFER")) {
            return this.parseBufferShape(state);
        }
        return null;
    }

    protected Shape parseBufferShape(State state) throws ParseException {
        state.nextExpect('(');
        Shape shape = this.shape(state);
        state.nextExpect(',');
        double distance = this.normDist(state.nextDouble());
        state.nextExpect(')');
        return shape.getBuffered(distance, this.ctx);
    }

    protected double normDist(double v) {
        return v;
    }

    protected Shape parsePointShape(State state) throws ParseException {
        if (state.nextIfEmptyAndSkipZM()) {
            return this.ctx.makePoint(Double.NaN, Double.NaN);
        }
        state.nextExpect('(');
        Point coordinate = this.point(state);
        state.nextExpect(')');
        return coordinate;
    }

    protected Shape parseMultiPointShape(State state) throws ParseException {
        if (state.nextIfEmptyAndSkipZM()) {
            return this.ctx.makeCollection(Collections.EMPTY_LIST);
        }
        ArrayList<Point> shapes = new ArrayList<Point>();
        state.nextExpect('(');
        do {
            boolean openParen = state.nextIf('(');
            Point coordinate = this.point(state);
            if (openParen) {
                state.nextExpect(')');
            }
            shapes.add(coordinate);
        } while (state.nextIf(','));
        state.nextExpect(')');
        return this.ctx.makeCollection(shapes);
    }

    protected Shape parseEnvelopeShape(State state) throws ParseException {
        state.nextExpect('(');
        double x1 = state.nextDouble();
        state.nextExpect(',');
        double x2 = state.nextDouble();
        state.nextExpect(',');
        double y2 = state.nextDouble();
        state.nextExpect(',');
        double y1 = state.nextDouble();
        state.nextExpect(')');
        return this.ctx.makeRectangle(this.ctx.normX(x1), this.ctx.normX(x2), this.ctx.normY(y1), this.ctx.normY(y2));
    }

    protected Shape parseLineStringShape(State state) throws ParseException {
        if (state.nextIfEmptyAndSkipZM()) {
            return this.ctx.makeLineString(Collections.emptyList());
        }
        List<Point> points = this.pointList(state);
        return this.ctx.makeLineString(points);
    }

    protected Shape parseMultiLineStringShape(State state) throws ParseException {
        if (state.nextIfEmptyAndSkipZM()) {
            return this.ctx.makeCollection(Collections.EMPTY_LIST);
        }
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        state.nextExpect('(');
        do {
            shapes.add(this.parseLineStringShape(state));
        } while (state.nextIf(','));
        state.nextExpect(')');
        return this.ctx.makeCollection(shapes);
    }

    protected Shape parseGeometryCollectionShape(State state) throws ParseException {
        if (state.nextIfEmptyAndSkipZM()) {
            return this.ctx.makeCollection(Collections.EMPTY_LIST);
        }
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        state.nextExpect('(');
        do {
            shapes.add(this.shape(state));
        } while (state.nextIf(','));
        state.nextExpect(')');
        return this.ctx.makeCollection(shapes);
    }

    protected Shape shape(State state) throws ParseException {
        String type = state.nextWord();
        Shape shape = this.parseShapeByType(state, type);
        if (shape == null) {
            throw new ParseException("Shape of type " + type + " is unknown", state.offset);
        }
        return shape;
    }

    protected List<Point> pointList(State state) throws ParseException {
        ArrayList<Point> sequence = new ArrayList<Point>();
        state.nextExpect('(');
        do {
            sequence.add(this.point(state));
        } while (state.nextIf(','));
        state.nextExpect(')');
        return sequence;
    }

    protected Point point(State state) throws ParseException {
        double x = state.nextDouble();
        double y = state.nextDouble();
        state.skipNextDoubles();
        return this.ctx.makePoint(this.ctx.normX(x), this.ctx.normY(y));
    }

    @Override
    public String getFormatName() {
        return "WKT";
    }

    static String readString(Reader reader) throws IOException {
        int numCharsRead;
        char[] arr = new char[1024];
        StringBuilder buffer = new StringBuilder();
        while ((numCharsRead = reader.read(arr, 0, arr.length)) != -1) {
            buffer.append(arr, 0, numCharsRead);
        }
        return buffer.toString();
    }

    @Override
    public Shape read(Reader reader) throws IOException, ParseException {
        return this.parse(WKTReader.readString(reader));
    }

    @Override
    public Shape read(Object value) throws IOException, ParseException, InvalidShapeException {
        return this.parse(value.toString());
    }

    @Override
    public Shape readIfSupported(Object value) throws InvalidShapeException {
        try {
            return this.parseIfSupported(value.toString());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public class State {
        public String rawString;
        public int offset;
        public String dimension;

        public State(String rawString) {
            this.rawString = rawString;
        }

        public SpatialContext getCtx() {
            return WKTReader.this.ctx;
        }

        public WKTReader getParser() {
            return WKTReader.this;
        }

        public String nextWord() throws ParseException {
            int startOffset = this.offset;
            while (this.offset < this.rawString.length() && Character.isJavaIdentifierPart(this.rawString.charAt(this.offset))) {
                ++this.offset;
            }
            if (startOffset == this.offset) {
                throw new ParseException("Word expected", startOffset);
            }
            String result2 = this.rawString.substring(startOffset, this.offset);
            this.nextIfWhitespace();
            return result2;
        }

        public boolean nextIfEmptyAndSkipZM() throws ParseException {
            if (this.eof()) {
                return false;
            }
            char c = this.rawString.charAt(this.offset);
            if (c == '(' || !Character.isJavaIdentifierPart(c)) {
                return false;
            }
            String word = this.nextWord();
            if (word.equalsIgnoreCase("EMPTY")) {
                return true;
            }
            this.dimension = word;
            if (this.eof()) {
                return false;
            }
            c = this.rawString.charAt(this.offset);
            if (c == '(' || !Character.isJavaIdentifierPart(c)) {
                return false;
            }
            word = this.nextWord();
            if (word.equalsIgnoreCase("EMPTY")) {
                return true;
            }
            throw new ParseException("Expected EMPTY because found dimension; but got [" + word + "]", this.offset);
        }

        public double nextDouble() throws ParseException {
            double result2;
            int startOffset = this.offset;
            this.skipDouble();
            if (startOffset == this.offset) {
                throw new ParseException("Expected a number", this.offset);
            }
            try {
                result2 = Double.parseDouble(this.rawString.substring(startOffset, this.offset));
            }
            catch (Exception e) {
                throw new ParseException(e.toString(), this.offset);
            }
            this.nextIfWhitespace();
            return result2;
        }

        public void skipDouble() {
            char c;
            int startOffset = this.offset;
            while (this.offset < this.rawString.length() && (Character.isDigit(c = this.rawString.charAt(this.offset)) || c == '.' || c == '-' || c == '+' || this.offset != startOffset && (c == 'e' || c == 'E'))) {
                ++this.offset;
            }
        }

        public void skipNextDoubles() {
            while (!this.eof()) {
                int startOffset = this.offset;
                this.skipDouble();
                if (startOffset == this.offset) {
                    return;
                }
                this.nextIfWhitespace();
            }
        }

        public void nextExpect(char expected) throws ParseException {
            if (this.eof()) {
                throw new ParseException("Expected [" + expected + "] found EOF", this.offset);
            }
            char c = this.rawString.charAt(this.offset);
            if (c != expected) {
                throw new ParseException("Expected [" + expected + "] found [" + c + "]", this.offset);
            }
            ++this.offset;
            this.nextIfWhitespace();
        }

        public final boolean eof() {
            return this.offset >= this.rawString.length();
        }

        public boolean nextIf(char expected) {
            if (!this.eof() && this.rawString.charAt(this.offset) == expected) {
                ++this.offset;
                this.nextIfWhitespace();
                return true;
            }
            return false;
        }

        public void nextIfWhitespace() {
            while (this.offset < this.rawString.length()) {
                if (!Character.isWhitespace(this.rawString.charAt(this.offset))) {
                    return;
                }
                ++this.offset;
            }
        }

        public String nextSubShapeString() throws ParseException {
            int startOffset = this.offset;
            int parenStack = 0;
            while (this.offset < this.rawString.length()) {
                char c = this.rawString.charAt(this.offset);
                if (c == ',') {
                    if (parenStack == 0) {
                        break;
                    }
                } else if (c == ')') {
                    if (parenStack == 0) break;
                    --parenStack;
                } else if (c == '(') {
                    ++parenStack;
                }
                ++this.offset;
            }
            if (parenStack != 0) {
                throw new ParseException("Unbalanced parenthesis", startOffset);
            }
            return this.rawString.substring(startOffset, this.offset);
        }
    }
}

