/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.partitioning.Partitioner;
import com.stratio.cassandra.lucene.partitioning.Partitioner$;
import com.stratio.cassandra.lucene.partitioning.PartitionerOnNone;
import com.stratio.cassandra.lucene.schema.Schema;
import com.stratio.cassandra.lucene.schema.SchemaBuilder;
import com.stratio.cassandra.lucene.util.SchemaValidator$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.schema.IndexMetadata;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0$mcD$sp;
import scala.runtime.java8.JFunction0$mcI$sp;
import scala.runtime.java8.JFunction0$mcZ$sp;
import scala.runtime.java8.JFunction1$mcDD$sp;
import scala.runtime.java8.JFunction1$mcII$sp;

public final class IndexOptions$ {
    public static IndexOptions$ MODULE$;
    private final String REFRESH_SECONDS_OPTION;
    private final double DEFAULT_REFRESH_SECONDS;
    private final String RAM_BUFFER_MB_OPTION;
    private final int DEFAULT_RAM_BUFFER_MB;
    private final String MAX_MERGE_MB_OPTION;
    private final int DEFAULT_MAX_MERGE_MB;
    private final String MAX_CACHED_MB_OPTION;
    private final int DEFAULT_MAX_CACHED_MB;
    private final String INDEXING_THREADS_OPTION;
    private final int DEFAULT_INDEXING_THREADS;
    private final String INDEXING_QUEUES_SIZE_OPTION;
    private final int DEFAULT_INDEXING_QUEUES_SIZE;
    private final String EXCLUDED_DATA_CENTERS_OPTION;
    private final List<String> DEFAULT_EXCLUDED_DATA_CENTERS;
    private final String DIRECTORY_PATH_OPTION;
    private final String INDEXES_DIR_NAME;
    private final String SCHEMA_OPTION;
    private final String PARTITIONER_OPTION;
    private final PartitionerOnNone DEFAULT_PARTITIONER;
    private final String SPARSE_OPTION;
    private final boolean DEFAULT_SPARSE;

    static {
        new IndexOptions$();
    }

    public String REFRESH_SECONDS_OPTION() {
        return this.REFRESH_SECONDS_OPTION;
    }

    public double DEFAULT_REFRESH_SECONDS() {
        return this.DEFAULT_REFRESH_SECONDS;
    }

    public String RAM_BUFFER_MB_OPTION() {
        return this.RAM_BUFFER_MB_OPTION;
    }

    public int DEFAULT_RAM_BUFFER_MB() {
        return this.DEFAULT_RAM_BUFFER_MB;
    }

    public String MAX_MERGE_MB_OPTION() {
        return this.MAX_MERGE_MB_OPTION;
    }

    public int DEFAULT_MAX_MERGE_MB() {
        return this.DEFAULT_MAX_MERGE_MB;
    }

    public String MAX_CACHED_MB_OPTION() {
        return this.MAX_CACHED_MB_OPTION;
    }

    public int DEFAULT_MAX_CACHED_MB() {
        return this.DEFAULT_MAX_CACHED_MB;
    }

    public String INDEXING_THREADS_OPTION() {
        return this.INDEXING_THREADS_OPTION;
    }

    public int DEFAULT_INDEXING_THREADS() {
        return this.DEFAULT_INDEXING_THREADS;
    }

    public String INDEXING_QUEUES_SIZE_OPTION() {
        return this.INDEXING_QUEUES_SIZE_OPTION;
    }

    public int DEFAULT_INDEXING_QUEUES_SIZE() {
        return this.DEFAULT_INDEXING_QUEUES_SIZE;
    }

    public String EXCLUDED_DATA_CENTERS_OPTION() {
        return this.EXCLUDED_DATA_CENTERS_OPTION;
    }

    public List<String> DEFAULT_EXCLUDED_DATA_CENTERS() {
        return this.DEFAULT_EXCLUDED_DATA_CENTERS;
    }

    public String DIRECTORY_PATH_OPTION() {
        return this.DIRECTORY_PATH_OPTION;
    }

    public String INDEXES_DIR_NAME() {
        return this.INDEXES_DIR_NAME;
    }

    public String SCHEMA_OPTION() {
        return this.SCHEMA_OPTION;
    }

    public String PARTITIONER_OPTION() {
        return this.PARTITIONER_OPTION;
    }

    public PartitionerOnNone DEFAULT_PARTITIONER() {
        return this.DEFAULT_PARTITIONER;
    }

    public String SPARSE_OPTION() {
        return this.SPARSE_OPTION;
    }

    public boolean DEFAULT_SPARSE() {
        return this.DEFAULT_SPARSE;
    }

    public void validate(java.util.Map<String, String> options, CFMetaData metadata) {
        Map<String, String> o = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()).toMap(Predef$.MODULE$.$conforms());
        this.parseRefresh(o);
        this.parseRamBufferMB(o);
        this.parseMaxMergeMB(o);
        this.parseMaxCachedMB(o);
        this.parseIndexingThreads(o);
        this.parseIndexingQueuesSize(o);
        this.parseExcludedDataCenters(o);
        this.parseSchema(o, metadata);
        this.parsePath(o, metadata, None$.MODULE$);
        this.parsePartitioner(o, metadata);
    }

    public double parseRefresh(Map<String, String> options) {
        return this.parseStrictlyPositiveDouble(options, this.REFRESH_SECONDS_OPTION(), this.DEFAULT_REFRESH_SECONDS());
    }

    public int parseRamBufferMB(Map<String, String> options) {
        return this.parseStrictlyPositiveInt(options, this.RAM_BUFFER_MB_OPTION(), this.DEFAULT_RAM_BUFFER_MB());
    }

    public int parseMaxMergeMB(Map<String, String> options) {
        return this.parseStrictlyPositiveInt(options, this.MAX_MERGE_MB_OPTION(), this.DEFAULT_MAX_MERGE_MB());
    }

    public int parseMaxCachedMB(Map<String, String> options) {
        return this.parseStrictlyPositiveInt(options, this.MAX_CACHED_MB_OPTION(), this.DEFAULT_MAX_CACHED_MB());
    }

    public int parseIndexingThreads(Map<String, String> options) {
        return this.parseInt(options, this.INDEXING_THREADS_OPTION(), this.DEFAULT_INDEXING_THREADS());
    }

    public int parseIndexingQueuesSize(Map<String, String> options) {
        return this.parseStrictlyPositiveInt(options, this.INDEXING_QUEUES_SIZE_OPTION(), this.DEFAULT_INDEXING_QUEUES_SIZE());
    }

    public List<String> parseExcludedDataCenters(Map<String, String> options) {
        return (List)options.get(this.EXCLUDED_DATA_CENTERS_OPTION()).map((Function1<String, List> & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])x$1.split(","))).map((Function1<String, String> & Serializable & scala.Serializable)x$2 -> x$2.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filterNot((Function1<String, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean(x$3.isEmpty())))).toList()).getOrElse((Function0<List> & Serializable & scala.Serializable)() -> this.DEFAULT_EXCLUDED_DATA_CENTERS());
    }

    public Path parsePath(Map<String, String> options, CFMetaData table, Option<IndexMetadata> index) {
        return (Path)options.get(this.DIRECTORY_PATH_OPTION()).map((Function1<String, Path> & Serializable & scala.Serializable)x$4 -> Paths.get(x$4, new String[0])).getOrElse((Function0<Path> & Serializable & scala.Serializable)() -> (Path)index.map((Function1<IndexMetadata, Path> & Serializable & scala.Serializable)index -> {
            Directories directories = new Directories(table);
            String basePath = directories.getDirectoryForNewSSTables().getAbsolutePath();
            return Paths.get(basePath + File.separator + this.INDEXES_DIR_NAME() + File.separator + index.name, new String[0]);
        }).orNull(Predef$.MODULE$.$conforms()));
    }

    public Schema parseSchema(Map<String, String> options, CFMetaData table) {
        return (Schema)options.get(this.SCHEMA_OPTION()).map((Function1<String, Schema> & Serializable & scala.Serializable)value -> {
            void v0;
            try {
                void var3_3;
                Schema schema = SchemaBuilder.fromJson(value).build();
                SchemaValidator$.MODULE$.validate(schema, table);
                v0 = var3_3;
            }
            catch (Exception e) {
                throw new IndexException(e, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' is invalid : ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.SCHEMA_OPTION(), e.getMessage()})));
            }
            return v0;
        }).getOrElse((Function0<Nothing$> & Serializable & scala.Serializable)() -> {
            throw new IndexException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' is required"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.SCHEMA_OPTION()})));
        });
    }

    public Partitioner parsePartitioner(Map<String, String> options, CFMetaData table) {
        return (Partitioner)options.get(this.PARTITIONER_OPTION()).map((Function1<String, Partitioner> & Serializable & scala.Serializable)value -> {
            Partitioner partitioner;
            try {
                partitioner = Partitioner$.MODULE$.fromJson(table, (String)value);
            }
            catch (Exception e) {
                throw new IndexException(e, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' is invalid : ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.PARTITIONER_OPTION(), e.getMessage()})));
            }
            return partitioner;
        }).getOrElse((Function0<PartitionerOnNone> & Serializable & scala.Serializable)() -> this.DEFAULT_PARTITIONER());
    }

    public boolean parseSparse(Map<String, String> options, CFMetaData table) {
        return BoxesRunTime.unboxToBoolean(options.get(this.SPARSE_OPTION()).map((Function1<String, Object> & Serializable & scala.Serializable)value -> BoxesRunTime.boxToBoolean(IndexOptions$.$anonfun$parseSparse$1(this, value))).getOrElse((JFunction0$mcZ$sp & scala.Serializable)() -> this.DEFAULT_SPARSE()));
    }

    private int parseInt(Map<String, String> options, String name, int n) {
        return BoxesRunTime.unboxToInt(options.get(name).map((Function1<String, Object> & Serializable & scala.Serializable)string -> BoxesRunTime.boxToInteger(IndexOptions$.$anonfun$parseInt$1(name, string))).getOrElse((JFunction0$mcI$sp & scala.Serializable)() -> n));
    }

    private int parseStrictlyPositiveInt(Map<String, String> options, String name, int n) {
        return BoxesRunTime.unboxToInt(options.get(name).map((Function1<String, Object> & Serializable & scala.Serializable)string -> BoxesRunTime.boxToInteger(IndexOptions$.$anonfun$parseStrictlyPositiveInt$1(name, string))).map((JFunction1$mcII$sp & scala.Serializable)integer -> {
            if (integer <= 0) {
                throw new IndexException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' must be strictly positive, found: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{name, BoxesRunTime.boxToInteger(integer)})));
            }
            return integer;
        }).getOrElse((JFunction0$mcI$sp & scala.Serializable)() -> n));
    }

    private double parseStrictlyPositiveDouble(Map<String, String> options, String name, double d2) {
        return BoxesRunTime.unboxToDouble(options.get(name).map((Function1<String, Object> & Serializable & scala.Serializable)string -> BoxesRunTime.boxToDouble(IndexOptions$.$anonfun$parseStrictlyPositiveDouble$1(name, string))).map((JFunction1$mcDD$sp & scala.Serializable)d -> {
            if (!(d > 0.0)) {
                throw new IndexException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' must be strictly positive, found: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{name, BoxesRunTime.boxToDouble(d)})));
            }
            return d;
        }).getOrElse((JFunction0$mcD$sp & scala.Serializable)() -> d2));
    }

    public static final /* synthetic */ boolean $anonfun$parseSparse$1(IndexOptions$ $this, String value) {
        boolean bl;
        try {
            bl = new StringOps(Predef$.MODULE$.augmentString(value)).toBoolean();
        }
        catch (Exception e) {
            throw new IndexException(e, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' is invalid : ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{$this.SPARSE_OPTION(), e.getMessage()})));
        }
        return bl;
    }

    public static final /* synthetic */ int $anonfun$parseInt$1(String name$3, String string) {
        int n;
        try {
            n = new StringOps(Predef$.MODULE$.augmentString(string)).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw new IndexException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' must be an integer, found: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{name$3, string})));
        }
        return n;
    }

    public static final /* synthetic */ int $anonfun$parseStrictlyPositiveInt$1(String name$2, String string) {
        int n;
        try {
            n = new StringOps(Predef$.MODULE$.augmentString(string)).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw new IndexException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' must be a strictly positive integer, found: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{name$2, string})));
        }
        return n;
    }

    public static final /* synthetic */ double $anonfun$parseStrictlyPositiveDouble$1(String name$1, String string) {
        double d;
        try {
            d = new StringOps(Predef$.MODULE$.augmentString(string)).toDouble();
        }
        catch (NumberFormatException numberFormatException) {
            throw new IndexException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' must be a strictly positive decimal, found: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{name$1, string})));
        }
        return d;
    }

    private IndexOptions$() {
        MODULE$ = this;
        this.REFRESH_SECONDS_OPTION = "refresh_seconds";
        this.DEFAULT_REFRESH_SECONDS = 60.0;
        this.RAM_BUFFER_MB_OPTION = "ram_buffer_mb";
        this.DEFAULT_RAM_BUFFER_MB = 64;
        this.MAX_MERGE_MB_OPTION = "max_merge_mb";
        this.DEFAULT_MAX_MERGE_MB = 5;
        this.MAX_CACHED_MB_OPTION = "max_cached_mb";
        this.DEFAULT_MAX_CACHED_MB = 30;
        this.INDEXING_THREADS_OPTION = "indexing_threads";
        this.DEFAULT_INDEXING_THREADS = Runtime.getRuntime().availableProcessors();
        this.INDEXING_QUEUES_SIZE_OPTION = "indexing_queues_size";
        this.DEFAULT_INDEXING_QUEUES_SIZE = 50;
        this.EXCLUDED_DATA_CENTERS_OPTION = "excluded_data_centers";
        this.DEFAULT_EXCLUDED_DATA_CENTERS = Nil$.MODULE$;
        this.DIRECTORY_PATH_OPTION = "directory_path";
        this.INDEXES_DIR_NAME = "lucene";
        this.SCHEMA_OPTION = "schema";
        this.PARTITIONER_OPTION = "partitioner";
        this.DEFAULT_PARTITIONER = new PartitionerOnNone();
        this.SPARSE_OPTION = "sparse";
        this.DEFAULT_SPARSE = false;
    }
}

