/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene;

import com.stratio.cassandra.lucene.IndexPostProcessor$;
import com.stratio.cassandra.lucene.IndexService;
import com.stratio.cassandra.lucene.column.Columns;
import com.stratio.cassandra.lucene.index.RAMIndex;
import com.stratio.cassandra.lucene.search.Search;
import com.stratio.cassandra.lucene.util.Logging;
import com.stratio.cassandra.lucene.util.SimplePartitionIterator;
import com.stratio.cassandra.lucene.util.SingleRowIterator;
import com.stratio.cassandra.lucene.util.SingleRowIterator$;
import com.stratio.cassandra.lucene.util.StartedTimeCounter;
import com.stratio.cassandra.lucene.util.TimeCounter$;
import com.stratio.cassandra.lucene.util.Tracer;
import com.stratio.cassandra.lucene.util.Tracing;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ReadQuery;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1$mcVI$sp;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud!B\u0001\u0003\u0003CY!AE%oI\u0016D\bk\\:u!J|7-Z:t_JT!a\u0001\u0003\u0002\r1,8-\u001a8f\u0015\t)a!A\u0005dCN\u001c\u0018M\u001c3sC*\u0011q\u0001C\u0001\bgR\u0014\u0018\r^5p\u0015\u0005I\u0011aA2p[\u000e\u0001QC\u0001\u0007-'\u0015\u0001Q\"F\u001d?!\tq1#D\u0001\u0010\u0015\t\u0001\u0012#\u0001\u0003mC:<'\"\u0001\n\u0002\t)\fg/Y\u0005\u0003)=\u0011aa\u00142kK\u000e$\b#\u0002\f\u001c;)jR\"A\f\u000b\u0005aI\u0012\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\u0005i\t\u0012\u0001B;uS2L!\u0001H\f\u0003\u0015\tKg)\u001e8di&|g\u000e\u0005\u0002\u001fQ5\tqD\u0003\u0002!C\u0005Q\u0001/\u0019:uSRLwN\\:\u000b\u0005\t\u001a\u0013A\u00013c\u0015\t)AE\u0003\u0002&M\u00051\u0011\r]1dQ\u0016T\u0011aJ\u0001\u0004_J<\u0017BA\u0015 \u0005E\u0001\u0016M\u001d;ji&|g.\u0013;fe\u0006$xN\u001d\t\u0003W1b\u0001\u0001B\u0003.\u0001\t\u0007aFA\u0001B#\tyS\u0007\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014GA\u0004O_RD\u0017N\\4\u0011\u0005Y:T\"A\u0011\n\u0005a\n#!\u0003*fC\u0012\fV/\u001a:z!\tQD(D\u0001<\u0015\tQ\"!\u0003\u0002>w\t9Aj\\4hS:<\u0007C\u0001\u001e@\u0013\t\u00015HA\u0004Ue\u0006\u001c\u0017N\\4\t\u0011\t\u0003!\u0011!Q\u0001\n\r\u000bqa]3sm&\u001cW\r\u0005\u0002E\u000b6\t!!\u0003\u0002G\u0005\ta\u0011J\u001c3fqN+'O^5dK\")\u0001\n\u0001C\u0001\u0013\u00061A(\u001b8jiz\"\"AS&\u0011\u0007\u0011\u0003!\u0006C\u0003C\u000f\u0002\u00071\tC\u0003N\u0001\u0011Ea*A\u0004qe>\u001cWm]:\u0015\u000buy\u0005k\u0016/\t\u000b\u0001b\u0005\u0019A\u000f\t\u000bEc\u0005\u0019\u0001*\u0002\rM,\u0017M]2i!\t\u0019V+D\u0001U\u0015\t\t&!\u0003\u0002W)\n11+Z1sG\"DQ\u0001\u0017'A\u0002e\u000bQ\u0001\\5nSR\u0004\"\u0001\r.\n\u0005m\u000b$aA%oi\")Q\f\u0014a\u00013\u0006\u0019an\\<\t\u000b}\u0003A\u0011\u00021\u0002\u000f\r|G\u000e\\3diR\u0011\u0011M\u001e\t\u0004E*lgBA2i\u001d\t!w-D\u0001f\u0015\t1'\"\u0001\u0004=e>|GOP\u0005\u0002e%\u0011\u0011.M\u0001\ba\u0006\u001c7.Y4f\u0013\tYGN\u0001\u0003MSN$(BA52!\u0011\u0001d\u000e]:\n\u0005=\f$A\u0002+va2,'\u0007\u0005\u00027c&\u0011!/\t\u0002\r\t\u0016\u001cwN]1uK\u0012\\U-\u001f\t\u0003uQL!!^\u001e\u0003#MKgn\u001a7f%><\u0018\n^3sCR|'\u000fC\u0003!=\u0002\u0007Q\u0004C\u0003y\u0001\u0011%\u00110A\u0002u_B$R!\b>}{zDQa_<A\u0002\u0005\fAA]8xg\")\u0011k\u001ea\u0001%\")\u0001l\u001ea\u00013\")Ql\u001ea\u00013\"9\u0011\u0011\u0001\u0001\u0005\n\u0005\r\u0011\u0001\u00033pGVlWM\u001c;\u0015\u0015\u0005\u0015\u0011\u0011CA\u000b\u0003G\t)\u0003\u0005\u0003\u0002\b\u00055QBAA\u0005\u0015\u0011\t\t!a\u0003\u000b\u0005\r!\u0013\u0002BA\b\u0003\u0013\u0011\u0001\u0002R8dk6,g\u000e\u001e\u0005\u0007\u0003'y\b\u0019\u00019\u0002\u0007-,\u0017\u0010C\u0004\u0002\u0018}\u0004\r!!\u0007\u0002\u0007I|w\u000f\u0005\u0003\u0002\u001c\u0005}QBAA\u000f\u0015\tY\u0018%\u0003\u0003\u0002\"\u0005u!a\u0001*po\")\u0011k a\u0001%\")Ql a\u00013&*\u0001!!\u000b\u0002.%\u0019\u00111\u0006\u0002\u0003%\u001d\u0013x.\u001e9Q_N$\bK]8dKN\u001cxN]\u0005\u0004\u0003_\u0011!\u0001\u0007*fC\u0012\u001cu.\\7b]\u0012\u0004vn\u001d;Qe>\u001cWm]:pe\u001e9\u00111\u0007\u0002\t\u0002\u0005U\u0012AE%oI\u0016D\bk\\:u!J|7-Z:t_J\u00042\u0001RA\u001c\r\u0019\t!\u0001#\u0001\u0002:M!\u0011qGA\u001e!\r\u0001\u0014QH\u0005\u0004\u0003\u007f\t$AB!osJ+g\rC\u0004I\u0003o!\t!a\u0011\u0015\u0005\u0005U\u0002BCA$\u0003o\u0011\r\u0011\"\u0001\u0002J\u0005A\u0011\nR0G\u0013\u0016cE)\u0006\u0002\u0002LA\u0019a\"!\u0014\n\u0007\u0005=sB\u0001\u0004TiJLgn\u001a\u0005\n\u0003'\n9\u0004)A\u0005\u0003\u0017\n\u0011\"\u0013#`\r&+E\n\u0012\u0011\t\u0015\u0005]\u0013q\u0007b\u0001\n\u0003\tI&\u0001\bG\u0013\u0016cEiU0U\u001f~cu*\u0011#\u0016\u0005\u0005m\u0003CBA/\u0003?\n\u0019'D\u0001\u001a\u0013\r\t\t'\u0007\u0002\u0004'\u0016$\b\u0003BA3\u0003[rA!a\u001a\u0002jA\u0011A-M\u0005\u0004\u0003W\n\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002P\u0005=$bAA6c!I\u00111OA\u001cA\u0003%\u00111L\u0001\u0010\r&+E\nR*`)>{FjT!EA\u0001")
public abstract class IndexPostProcessor<A extends ReadQuery>
implements BiFunction<PartitionIterator, A, PartitionIterator>,
Logging,
Tracing {
    private final IndexService service;
    private final Tracer tracer;
    private final Logger logger;

    public static Set<String> FIELDS_TO_LOAD() {
        return IndexPostProcessor$.MODULE$.FIELDS_TO_LOAD();
    }

    public static String ID_FIELD() {
        return IndexPostProcessor$.MODULE$.ID_FIELD();
    }

    @Override
    public <V> BiFunction<PartitionIterator, A, V> andThen(Function<? super PartitionIterator, ? extends V> x$1) {
        return BiFunction.super.andThen(x$1);
    }

    @Override
    public Tracer tracer() {
        return this.tracer;
    }

    @Override
    public void com$stratio$cassandra$lucene$util$Tracing$_setter_$tracer_$eq(Tracer x$1) {
        this.tracer = x$1;
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public PartitionIterator process(PartitionIterator partitions, Search search, int limit, int now) {
        if (search.requiresFullScan()) {
            List<Tuple2<DecoratedKey, SingleRowIterator>> rows = this.collect(partitions);
            if (search.requiresPostProcessing() && rows.nonEmpty()) {
                return this.top(rows, search, limit, now);
            }
        }
        return partitions;
    }

    private List<Tuple2<DecoratedKey, SingleRowIterator>> collect(PartitionIterator partitions) {
        BoxedUnit boxedUnit;
        StartedTimeCounter time = TimeCounter$.MODULE$.start();
        ListBuffer rows = (ListBuffer)ListBuffer$.MODULE$.apply(Nil$.MODULE$);
        JavaConverters$.MODULE$.asScalaIteratorConverter(partitions).asScala().foreach((Function1<RowIterator, Object> & Serializable & scala.Serializable)partition -> {
            IndexPostProcessor.$anonfun$collect$1(rows, partition);
            return BoxedUnit.UNIT;
        });
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Collected ", " rows in ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(rows.size()), time})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return rows.toList();
    }

    private PartitionIterator top(List<Tuple2<DecoratedKey, SingleRowIterator>> rows, Search search, int limit, int now) {
        SimplePartitionIterator simplePartitionIterator;
        StartedTimeCounter time = TimeCounter$.MODULE$.start();
        try (RAMIndex index = new RAMIndex(this.service.schema().analyzer);){
            BoxedUnit boxedUnit;
            rows.indices().foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)id -> {
                Tuple2 tuple2 = (Tuple2)rows.apply(id);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                DecoratedKey key = (DecoratedKey)tuple2._1();
                SingleRowIterator rowIterator = (SingleRowIterator)tuple2._2();
                Tuple2<DecoratedKey, SingleRowIterator> tuple22 = new Tuple2<DecoratedKey, SingleRowIterator>(key, rowIterator);
                Tuple2<DecoratedKey, SingleRowIterator> tuple23 = tuple22;
                DecoratedKey key2 = tuple23._1();
                SingleRowIterator rowIterator2 = tuple23._2();
                Row row = rowIterator2.row();
                Document doc = this.document(key2, row, search, now);
                doc.add(new StoredField(IndexPostProcessor$.MODULE$.ID_FIELD(), id));
                index.add(doc);
            });
            Query query = search.postProcessingQuery(this.service.schema());
            Sort sort = this.service.sort(search);
            Seq<Tuple2<Document, ScoreDoc>> docs = index.search(query, sort, Predef$.MODULE$.int2Integer(limit), IndexPostProcessor$.MODULE$.FIELDS_TO_LOAD());
            Seq<SingleRowIterator> merged = docs.withFilter((Function1<Tuple2, Object> & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(IndexPostProcessor.$anonfun$top$2(check$ifrefutable$1))).map((Function1<Tuple2, SingleRowIterator> & Serializable & scala.Serializable)x$2 -> {
                Tuple2 tuple2 = x$2;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Document doc = (Document)tuple2._1();
                ScoreDoc score = (ScoreDoc)tuple2._2();
                int id = new StringOps(Predef$.MODULE$.augmentString(doc.get(IndexPostProcessor$.MODULE$.ID_FIELD()))).toInt();
                SingleRowIterator rowIterator = (SingleRowIterator)((Tuple2)rows.apply(id))._2();
                SingleRowIterator singleRowIterator = rowIterator.decorated((Function1<Row, Row> & Serializable & scala.Serializable)row -> $this.service.expressionMapper().decorate((Row)row, score, now));
                return singleRowIterator;
            }, Seq$.MODULE$.canBuildFrom());
            this.tracer().trace((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Lucene post-process ", " collected rows to ", " rows"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(rows.size()), BoxesRunTime.boxToInteger(merged.size())})));
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Post-processed ", " rows to ", " rows in ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(rows.size()), BoxesRunTime.boxToInteger(merged.size()), time})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            simplePartitionIterator = new SimplePartitionIterator(merged);
        }
        return simplePartitionIterator;
    }

    private Document document(DecoratedKey key, Row row, Search search, int now) {
        Document document = new Document();
        Clustering clustering = row.clustering();
        Columns columns = this.service.columnsMapper().columns(key, row, now);
        this.service.keyIndexableFields(key, clustering).foreach((Function1<IndexableField, Object> & Serializable & scala.Serializable)x$1 -> {
            document.add(x$1);
            return BoxedUnit.UNIT;
        });
        this.service.schema().postProcessingIndexableFields(columns, search).forEach(x$3 -> document.add((IndexableField)x$3));
        return document;
    }

    public static final /* synthetic */ void $anonfun$collect$1(ListBuffer rows$2, RowIterator partition) {
        try {
            DecoratedKey key = partition.partitionKey();
            while (partition.hasNext()) {
                rows$2.$plus$eq(new Tuple2<DecoratedKey, SingleRowIterator>(key, new SingleRowIterator(partition, SingleRowIterator$.MODULE$.$lessinit$greater$default$2(), SingleRowIterator$.MODULE$.$lessinit$greater$default$3())));
            }
        }
        finally {
            partition.close();
        }
    }

    public static final /* synthetic */ boolean $anonfun$top$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public IndexPostProcessor(IndexService service) {
        this.service = service;
        StrictLogging.$init$(this);
        Tracing.$init$(this);
    }
}

