/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene;

import com.stratio.cassandra.lucene.Index;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.IndexPagingState$;
import com.stratio.cassandra.lucene.IndexQueryHandler$;
import com.stratio.cassandra.lucene.partitioning.Partitioner;
import com.stratio.cassandra.lucene.search.Search;
import com.stratio.cassandra.lucene.util.Logging;
import com.stratio.cassandra.lucene.util.StartedTimeCounter;
import com.stratio.cassandra.lucene.util.TimeCounter$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cql3.BatchQueryOptions;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryHandler;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.statements.BatchStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.LuceneStorageProxy;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MD5Digest;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.AbstractTraversable;
import scala.collection.GenMap;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t-b\u0001B\u0001\u0003\u0001-\u0011\u0011#\u00138eKb\fV/\u001a:z\u0011\u0006tG\r\\3s\u0015\t\u0019A!\u0001\u0004mk\u000e,g.\u001a\u0006\u0003\u000b\u0019\t\u0011bY1tg\u0006tGM]1\u000b\u0005\u001dA\u0011aB:ue\u0006$\u0018n\u001c\u0006\u0002\u0013\u0005\u00191m\\7\u0004\u0001M!\u0001\u0001\u0004\u000b !\ti!#D\u0001\u000f\u0015\ty\u0001#\u0001\u0003mC:<'\"A\t\u0002\t)\fg/Y\u0005\u0003'9\u0011aa\u00142kK\u000e$\bCA\u000b\u001e\u001b\u00051\"BA\f\u0019\u0003\u0011\u0019\u0017\u000f\\\u001a\u000b\u0005\u0015I\"B\u0001\u000e\u001c\u0003\u0019\t\u0007/Y2iK*\tA$A\u0002pe\u001eL!A\b\f\u0003\u0019E+XM]=IC:$G.\u001a:\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\t\u0012\u0011\u0001B;uS2L!\u0001J\u0011\u0003\u000f1{wmZ5oO\")a\u0005\u0001C\u0001O\u00051A(\u001b8jiz\"\u0012\u0001\u000b\t\u0003S\u0001i\u0011AA\u0003\u0005W\u0001\u0001AFA\u0004QCfdw.\u00193\u0011\t5z\u0013GP\u0007\u0002])\u0011!\u0005E\u0005\u0003a9\u00121!T1q!\t\u00114H\u0004\u00024sA\u0011AgN\u0007\u0002k)\u0011aGC\u0001\u0007yI|w\u000e\u001e \u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0002\rA\u0013X\rZ3g\u0013\taTH\u0001\u0004TiJLgn\u001a\u0006\u0003u]\u0002\"a\u0010\"\u000e\u0003\u0001S!!\u0011\t\u0002\u00079Lw.\u0003\u0002D\u0001\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000b\u0015\u0003A\u0011\t$\u0002\u000fA\u0014X\r]1sKR!q\t\u00180g!\tA\u0015L\u0004\u0002J-:\u0011!j\u0015\b\u0003\u0017Fs!\u0001\u0014)\u000f\u00055{eB\u0001\u001bO\u0013\u0005a\u0012B\u0001\u000e\u001c\u0013\t)\u0011$\u0003\u0002S1\u0005IAO]1ogB|'\u000f^\u0005\u0003)V\u000b\u0001\"\\3tg\u0006<Wm\u001d\u0006\u0003%bI!a\u0016-\u0002\u001bI+7/\u001e7u\u001b\u0016\u001c8/Y4f\u0015\t!V+\u0003\u0002[7\nA\u0001K]3qCJ,GM\u0003\u0002X1\")Q\f\u0012a\u0001c\u0005)\u0011/^3ss\")q\f\u0012a\u0001A\u0006)1\u000f^1uKB\u0011\u0011\rZ\u0007\u0002E*\u00111\rG\u0001\bg\u0016\u0014h/[2f\u0013\t)'M\u0001\u0006Rk\u0016\u0014\u0018p\u0015;bi\u0016DQa\u001a#A\u0002!\fq\u0001]1zY>\fG\r\u0005\u0002jU5\t\u0001\u0001C\u0003l\u0001\u0011\u0005C.A\u0006hKR\u0004&/\u001a9be\u0016$GCA7w!\tqGO\u0004\u0002pe6\t\u0001O\u0003\u0002r-\u0005Q1\u000f^1uK6,g\u000e^:\n\u0005M\u0004\u0018a\u0004)beN,Gm\u0015;bi\u0016lWM\u001c;\n\u0005i+(BA:q\u0011\u00159(\u000e1\u0001y\u0003\tIG\r\u0005\u0002zy6\t!P\u0003\u0002|1\u0005)Q\u000f^5mg&\u0011QP\u001f\u0002\n\u001b\u0012+D)[4fgRDaa \u0001\u0005B\u0005\u0005\u0011\u0001F4fiB\u0013X\r]1sK\u00124uN\u001d+ie&4G\u000fF\u0002n\u0003\u0007Aaa\u001e@A\u0002\u0005\u0015\u0001cA\u0007\u0002\b%\u0019\u0011\u0011\u0002\b\u0003\u000f%sG/Z4fe\"9\u0011Q\u0002\u0001\u0005B\u0005=\u0011\u0001\u00049s_\u000e,7o\u001d\"bi\u000eDG\u0003DA\t\u00033\t\u0019#!\n\u00020\u0005E\u0002\u0003BA\n\u0003+i\u0011\u0001W\u0005\u0004\u0003/A&!\u0004*fgVdG/T3tg\u0006<W\r\u0003\u0005\u0002\u001c\u0005-\u0001\u0019AA\u000f\u0003%\u0019H/\u0019;f[\u0016tG\u000fE\u0002p\u0003?I1!!\tq\u00059\u0011\u0015\r^2i'R\fG/Z7f]RDaaXA\u0006\u0001\u0004\u0001\u0007\u0002CA\u0014\u0003\u0017\u0001\r!!\u000b\u0002\u000f=\u0004H/[8ogB\u0019Q#a\u000b\n\u0007\u00055bCA\tCCR\u001c\u0007.U;fef|\u0005\u000f^5p]NDaaZA\u0006\u0001\u0004A\u0007\u0002CA\u001a\u0003\u0017\u0001\r!!\u000e\u0002%E,XM]=Ti\u0006\u0014HOT1o_RKW.\u001a\t\u0005\u0003o\tI$D\u00018\u0013\r\tYd\u000e\u0002\u0005\u0019>tw\rC\u0004\u0002@\u0001!\t%!\u0011\u0002\u001fA\u0014xnY3tgB\u0013X\r]1sK\u0012$B\"!\u0005\u0002D\u0005-\u0013QJA+\u0003/B\u0001\"a\u0007\u0002>\u0001\u0007\u0011Q\t\t\u0004+\u0005\u001d\u0013bAA%-\ta1)\u0015'Ti\u0006$X-\\3oi\"1q,!\u0010A\u0002\u0001D\u0001\"a\n\u0002>\u0001\u0007\u0011q\n\t\u0004+\u0005E\u0013bAA*-\ta\u0011+^3ss>\u0003H/[8og\"1q-!\u0010A\u0002!D\u0001\"a\r\u0002>\u0001\u0007\u0011Q\u0007\u0005\b\u00037\u0002A\u0011IA/\u0003\u001d\u0001(o\\2fgN$B\"!\u0005\u0002`\u0005\u0005\u00141MA3\u0003OBa!XA-\u0001\u0004\t\u0004BB0\u0002Z\u0001\u0007\u0001\r\u0003\u0005\u0002(\u0005e\u0003\u0019AA(\u0011\u00199\u0017\u0011\fa\u0001Q\"A\u00111GA-\u0001\u0004\t)\u0004C\u0004\u0002l\u0001!\t!!\u001c\u0002!A\u0014xnY3tgN#\u0018\r^3nK:$HCCA\t\u0003_\n\t(a\u001d\u0002v!A\u00111DA5\u0001\u0004\t)\u0005\u0003\u0004`\u0003S\u0002\r\u0001\u0019\u0005\t\u0003O\tI\u00071\u0001\u0002P!A\u00111GA5\u0001\u0004\t)\u0004C\u0004\u0002z\u0001!\t!a\u001f\u0002#1,8-\u001a8f\u000bb\u0004(/Z:tS>t7\u000f\u0006\u0004\u0002~\u0005\u0015\u0016q\u0016\t\be\u0005}\u0014\u0011QAP\u0013\t\u0001T\b\u0005\u0003\u0002\u0004\u0006ee\u0002BAC\u0003'sA!a\"\u0002\u000e:\u00191*!#\n\u0007\u0005-\u0005$\u0001\u0002eE&!\u0011qRAI\u0003\u00191\u0017\u000e\u001c;fe*\u0019\u00111\u0012\r\n\t\u0005U\u0015qS\u0001\n%><h)\u001b7uKJTA!a$\u0002\u0012&!\u00111TAO\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0005\u0003+\u000b9\nE\u0002*\u0003CK1!a)\u0003\u0005\u0015Ie\u000eZ3y\u0011!\t9+a\u001eA\u0002\u0005%\u0016AB:fY\u0016\u001cG\u000fE\u0002p\u0003WK1!!,q\u0005=\u0019V\r\\3diN#\u0018\r^3nK:$\b\u0002CA\u0014\u0003o\u0002\r!a\u0014\t\u000f\u0005M\u0006\u0001\"\u0001\u00026\u00069Q\r_3dkR,GCCA\t\u0003o\u000bI,a/\u0002>\"A\u00111DAY\u0001\u0004\t)\u0005\u0003\u0004`\u0003c\u0003\r\u0001\u0019\u0005\t\u0003O\t\t\f1\u0001\u0002P!A\u00111GAY\u0001\u0004\t)\u0004C\u0004\u0002B\u0002!\t!a1\u0002%\u0015DXmY;uK2+8-\u001a8f#V,'/\u001f\u000b\r\u0003#\t)-a2\u0002J\u0006-\u0017q\u001a\u0005\t\u0003O\u000by\f1\u0001\u0002*\"1q,a0A\u0002\u0001D\u0001\"a\n\u0002@\u0002\u0007\u0011q\n\u0005\t\u0003\u001b\fy\f1\u0001\u0002~\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0011!\t\u0019$a0A\u0002\u0005U\u0002bBAj\u0001\u0011\u0005\u0011Q[\u0001\u0019Kb,7-\u001e;f'>\u0014H/\u001a3Mk\u000e,g.Z)vKJLH\u0003DAl\u0003;\fy.!9\u0002d\u0006M\bc\u0001%\u0002Z&\u0019\u00111\\.\u0003\tI{wo\u001d\u0005\t\u0003O\u000b\t\u000e1\u0001\u0002*\"1q,!5A\u0002\u0001D\u0001\"a\n\u0002R\u0002\u0007\u0011q\n\u0005\t\u0003K\f\t\u000e1\u0001\u0002h\u0006Y\u0001/\u0019:uSRLwN\\3s!\u0011\tI/a<\u000e\u0005\u0005-(bAAw\u0005\u0005a\u0001/\u0019:uSRLwN\\5oO&!\u0011\u0011_Av\u0005-\u0001\u0016M\u001d;ji&|g.\u001a:\t\u0011\u0005M\u0012\u0011\u001ba\u0001\u0003k9q!a>\u0003\u0011\u0003\tI0A\tJ]\u0012,\u00070U;fefD\u0015M\u001c3mKJ\u00042!KA~\r\u0019\t!\u0001#\u0001\u0002~N!\u00111`A\u0000!\u0011\t9D!\u0001\n\u0007\t\rqG\u0001\u0004B]f\u0014VM\u001a\u0005\bM\u0005mH\u0011\u0001B\u0004)\t\tI\u0010\u0003\u0006\u0003\f\u0005m(\u0019!C\u0001\u0005\u001b\ta\u0002\u001d:pG\u0016\u001c8OU3tk2$8/\u0006\u0002\u0003\u0010A!!\u0011\u0003B\f\u001b\t\u0011\u0019BC\u0002\u0003\u00169\tqA]3gY\u0016\u001cG/\u0003\u0003\u0003\u001a\tM!AB'fi\"|G\rC\u0005\u0003\u001e\u0005m\b\u0015!\u0003\u0003\u0010\u0005y\u0001O]8dKN\u001c(+Z:vYR\u001c\b\u0005\u0003\u0005\u0003\"\u0005mH\u0011\u0001B\u0012\u0003!\t7\r^5wCR,GC\u0001B\u0013!\u0011\t9Da\n\n\u0007\t%rG\u0001\u0003V]&$\b")
public class IndexQueryHandler
implements QueryHandler,
Logging {
    private final Logger logger;

    public static void activate() {
        IndexQueryHandler$.MODULE$.activate();
    }

    public static Method processResults() {
        return IndexQueryHandler$.MODULE$.processResults();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ResultMessage.Prepared prepare(String query, QueryState state, Map<String, ByteBuffer> payload) {
        return QueryProcessor.instance.prepare(query, state);
    }

    public ParsedStatement.Prepared getPrepared(MD5Digest id) {
        return QueryProcessor.instance.getPrepared(id);
    }

    public ParsedStatement.Prepared getPreparedForThrift(Integer id) {
        return QueryProcessor.instance.getPreparedForThrift(id);
    }

    public ResultMessage processBatch(BatchStatement statement, QueryState state, BatchQueryOptions options, Map<String, ByteBuffer> payload, long queryStartNanoTime) {
        return QueryProcessor.instance.processBatch(statement, state, options, payload, queryStartNanoTime);
    }

    public ResultMessage processPrepared(CQLStatement statement, QueryState state, QueryOptions options, Map<String, ByteBuffer> payload, long queryStartNanoTime) {
        QueryProcessor.metrics.preparedStatementsExecuted.inc();
        return this.processStatement(statement, state, options, queryStartNanoTime);
    }

    public ResultMessage process(String query, QueryState state, QueryOptions options, Map<String, ByteBuffer> payload, long queryStartNanoTime) {
        CQLStatement prepared;
        block1: {
            ParsedStatement.Prepared p = QueryProcessor.getStatement((String)query, (ClientState)state.getClientState());
            options.prepare(p.boundNames);
            prepared = p.statement;
            if (prepared.getBoundTerms() != options.getValues().size()) {
                throw new InvalidRequestException("Invalid amount of bind variables");
            }
            if (state.getClientState().isInternal) break block1;
            QueryProcessor.metrics.regularStatementsExecuted.inc();
        }
        return this.processStatement(prepared, state, options, queryStartNanoTime);
    }

    public ResultMessage processStatement(CQLStatement statement, QueryState state, QueryOptions options, long queryStartNanoTime) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Process ", " @CL.", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{statement, options.getConsistency()})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ClientState clientState = state.getClientState();
        statement.checkAccess(clientState);
        statement.validate(clientState);
        CQLStatement cQLStatement = statement;
        if (cQLStatement instanceof SelectStatement) {
            SelectStatement selectStatement = (SelectStatement)cQLStatement;
            scala.collection.immutable.Map<RowFilter.Expression, Index> expressions = this.luceneExpressions(selectStatement, options);
            if (expressions.nonEmpty()) {
                BoxedUnit boxedUnit2;
                ResultMessage resultMessage;
                StartedTimeCounter time = TimeCounter$.MODULE$.start();
                try {
                    try {
                        resultMessage = this.executeLuceneQuery(selectStatement, state, options, expressions, queryStartNanoTime);
                    }
                    catch (ReflectiveOperationException e) {
                        throw new IndexException(e);
                    }
                }
                catch (Throwable throwable) {
                    BoxedUnit boxedUnit3;
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Lucene search total time: ", "\\n"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{time})));
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Lucene search total time: ", "\\n"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{time})));
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                return resultMessage;
            }
            BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
        }
        return this.execute(statement, state, options, queryStartNanoTime);
    }

    public scala.collection.immutable.Map<RowFilter.Expression, Index> luceneExpressions(SelectStatement select, QueryOptions options) {
        GenMap map = LinkedHashMap$.MODULE$.empty();
        List expressions = select.getRowFilter(options).getExpressions();
        ColumnFamilyStore cfs = Keyspace.open((String)select.keyspace()).getColumnFamilyStore(select.columnFamily());
        Iterable indexes = ((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(cfs.indexManager.listIndexes()).asScala()).collect(new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends org.apache.cassandra.index.Index, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Index index;
                A1 A1 = x1;
                Index index2 = A1 instanceof Index ? (index = (Index)A1) : function1.apply(x1);
                return (B1)index2;
            }

            public final boolean isDefinedAt(org.apache.cassandra.index.Index x1) {
                org.apache.cassandra.index.Index index = x1;
                boolean bl = index instanceof Index;
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        expressions.forEach(arg_0 -> IndexQueryHandler.$anonfun$luceneExpressions$1((LinkedHashMap)map, cfs, indexes, arg_0));
        return ((AbstractTraversable)((Object)map)).toMap(Predef$.MODULE$.$conforms());
    }

    public ResultMessage execute(CQLStatement statement, QueryState state, QueryOptions options, long queryStartNanoTime) {
        ResultMessage result2 = statement.execute(state, options, queryStartNanoTime);
        return result2 == null ? new ResultMessage.Void() : result2;
    }

    public ResultMessage executeLuceneQuery(SelectStatement select, QueryState state, QueryOptions options, scala.collection.immutable.Map<RowFilter.Expression, Index> expressions, long queryStartNanoTime) {
        if (expressions.size() > 1) {
            throw new InvalidRequestException("Lucene index only supports one search expression per query.");
        }
        if (select.getPerPartitionLimit(options) < Integer.MAX_VALUE) {
            throw new InvalidRequestException("Lucene index doesn't support PER PARTITION LIMIT");
        }
        Tuple2 tuple2 = (Tuple2)expressions.head();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        RowFilter.Expression expression = (RowFilter.Expression)tuple2._1();
        Index index = (Index)tuple2._2();
        Tuple2<RowFilter.Expression, Index> tuple22 = new Tuple2<RowFilter.Expression, Index>(expression, index);
        Tuple2<RowFilter.Expression, Index> tuple23 = tuple22;
        RowFilter.Expression expression2 = tuple23._1();
        Index index2 = tuple23._2();
        Search search = index2.validate(expression2);
        Partitioner partitioner = index2.service().partitioner();
        int limit = select.getLimit(options);
        int page = select.getSelection().isAggregate() && options.getPageSize() <= 0 ? 10000 : options.getPageSize();
        return search.requiresPostProcessing() && page > 0 && page < limit ? this.executeSortedLuceneQuery(select, state, options, partitioner, queryStartNanoTime) : this.execute((CQLStatement)select, state, options, queryStartNanoTime);
    }

    /*
     * Unable to fully structure code
     */
    public ResultMessage.Rows executeSortedLuceneQuery(SelectStatement select, QueryState state, QueryOptions options, Partitioner partitioner, long queryStartNanoTime) {
        consistency = options.getConsistency();
        RequestValidations.checkNotNull((Object)consistency, (String)"Invalid empty consistency level", (Object[])new Object[0]);
        consistency.validateForRead(select.keyspace());
        now = FBUtilities.nowInSeconds();
        limit = select.getLimit(options);
        userPerPartitionLimit = select.getPerPartitionLimit(options);
        page = options.getPageSize();
        pagingState = IndexPagingState$.MODULE$.build(options.getPagingState(), limit);
        remaining = Math.min(page, pagingState.remaining());
        query = select.getQuery(options, now, remaining, userPerPartitionLimit, page);
        pagingState.rewrite(query);
        var17_14 = query;
        if (!(var17_14 instanceof SinglePartitionReadCommand.Group)) ** GOTO lbl-1000
        var18_15 = (SinglePartitionReadCommand.Group)var17_14;
        if (var18_15.commands.size() > 1) {
            var7_16 = LuceneStorageProxy.read(var18_15, consistency, queryStartNanoTime);
        } else lbl-1000:
        // 2 sources

        {
            var7_16 = query.execute(consistency, state.getClientState(), queryStartNanoTime);
        }
        data = var7_16;
        try {
            processedData = pagingState.update(query, data, consistency, partitioner);
            rows = (ResultMessage.Rows)IndexQueryHandler$.MODULE$.processResults().invoke((Object)select, new Object[]{processedData, options, BoxesRunTime.boxToInteger(now), BoxesRunTime.boxToInteger(page)});
            rows.result.metadata.setHasMorePages(pagingState.toPagingState());
            v0 = rows;
        }
        finally {
            if (data != null) {
                data.close();
            }
        }
        return v0;
    }

    public static final /* synthetic */ void $anonfun$luceneExpressions$1(LinkedHashMap map$1, ColumnFamilyStore cfs$1, Iterable indexes$1, RowFilter.Expression x0$1) {
        RowFilter.Expression expression = x0$1;
        if (expression instanceof RowFilter.CustomExpression) {
            BoxedUnit boxedUnit;
            String clazz;
            RowFilter.CustomExpression customExpression = (RowFilter.CustomExpression)expression;
            String string = clazz = (String)customExpression.getTargetIndex().options.get("class_name");
            String string2 = Index.class.getCanonicalName();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Index index = (Index)cfs$1.indexManager.getIndex(customExpression.getTargetIndex());
                map$1.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(customExpression), index));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (expression != null) {
            RowFilter.Expression expression2 = expression;
            ((IterableLike)indexes$1.filter((Function1<Index, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.supportsExpression(expression2.column(), expression2.operator())))).foreach((Function1<Index, Option> & Serializable & scala.Serializable)x$2 -> map$1.put(expression2, x$2));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(expression);
        }
    }

    public IndexQueryHandler() {
        StrictLogging.$init$(this);
    }
}

